/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.Collection;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.dnd.ItemTransfer;
import org.eclipse.scada.vi.data.RegistrationManager;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public final class DragHelper {
    private DragHelper() {
    }

    protected static void setItemUriData(DragSourceEvent event, Collection<Item> items) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (Item item : items) {
            if (cnt > 0) {
                sb.append("\n");
            }
            sb.append(item.getConnectionString());
            sb.append("#");
            sb.append(item.getId());
            ++cnt;
        }
        event.data = sb.toString();
    }

    public static void addDragSupport(Control control, final RegistrationManager registrationManager) {
        Transfer[] types = new Transfer[]{ItemTransfer.getInstance(), TextTransfer.getInstance()};
        DragSource source = new DragSource(control, 7);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                if (registrationManager.getItems().isEmpty()) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                Collection items = registrationManager.getItems();
                if (ItemTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = items.toArray(new Item[items.size()]);
                } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    DragHelper.setItemUriData(event, items);
                }
            }
        });
    }
}

