/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets.control;

import org.eclipse.scada.core.ui.connection.login.SessionManager;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.da.client.dataitem.details.dialog.DataItemDetailsDialog;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.vi.data.RegistrationManager;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.scada.vi.details.swt.widgets.DragHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ControlImage
extends Composite
implements RegistrationManager.Listener {
    private static final String detailsDialogRole = System.getProperty("org.eclipse.scada.vi.details.swt.widgets.roles.detailsDialog", "admin");
    private final Label state;
    private Composite clientSpace;
    private final StyleBlinker blinker;
    private Item detailItem;
    private final RegistrationManager registrationManager;
    private final StateStyler styler;

    public ControlImage(Composite parent, RegistrationManager registrationManager) {
        this(parent, 0, registrationManager);
    }

    public ControlImage(Composite parent, int style, RegistrationManager registrationManager) {
        super(parent, style);
        this.registrationManager = registrationManager;
        registrationManager.addListener((RegistrationManager.Listener)this);
        RowLayout layout = new RowLayout(256);
        layout.wrap = false;
        layout.center = true;
        layout.spacing = 3;
        layout.pack = true;
        this.setLayout((Layout)layout);
        this.state = new Label((Composite)this, 0);
        DragHelper.addDragSupport((Control)this.state, registrationManager);
        this.state.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ControlImage.this.openDetails();
            }
        });
        this.state.setImage(Activator.getDefault().getImageRegistry().get("attr.ok"));
        this.blinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle style) {
                ControlImage.this.handleStyleUpdate(style);
            }
        };
        this.styler = new StateStyler((StyleHandler)this.blinker);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ControlImage.this.handleDispose();
            }
        });
    }

    public void setDetailItem(Item detailItem) {
        this.detailItem = detailItem;
    }

    public Item getDetailItem() {
        return this.detailItem;
    }

    protected void openDetails() {
        if (this.detailItem == null) {
            return;
        }
        if (SessionManager.getDefault().hasRole(detailsDialogRole)) {
            DataItemDetailsDialog dlg = new DataItemDetailsDialog(this.getShell(), this.detailItem);
            dlg.open();
        }
    }

    protected void handleStyleUpdate(StyleBlinker.CurrentStyle style) {
        if (this.state.isDisposed()) {
            return;
        }
        Image image = style.image;
        if (image == null) {
            this.state.setImage(Activator.getDefault().getImageRegistry().get("attr.ok"));
        } else {
            this.state.setImage(image);
        }
    }

    protected void handleDispose() {
        this.registrationManager.removeListener((RegistrationManager.Listener)this);
        this.styler.dispose();
        this.blinker.dispose();
    }

    public Composite getClientSpace() {
        if (this.clientSpace == null) {
            this.clientSpace = new Composite((Composite)this, 0);
            this.clientSpace.setLayout((Layout)new RowLayout(256));
        }
        return this.clientSpace;
    }

    public void triggerDataUpdate() {
        SummaryInformation summaryInformation = new SummaryInformation(this.registrationManager.getData());
        this.styler.style(summaryInformation.getStateInformation());
    }
}

