/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.information;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.core.connection.provider.info.ConnectionInformationProvider;
import org.eclipse.scada.core.ui.connection.information.InformationBean;
import org.eclipse.scada.utils.stats.StatisticEntry;

public class ConnectionInformationWrapper
extends WritableSet {
    private final ConnectionInformationProvider provider;
    private final Map<Object, InformationBean> beans = new HashMap<Object, InformationBean>();

    public ConnectionInformationWrapper(ConnectionInformationProvider provider) {
        this.provider = provider;
        this.timerUpdate();
    }

    protected void timerUpdate() {
        if (this.isDisposed()) {
            return;
        }
        this.update();
        this.getRealm().timerExec(1000, new Runnable(){

            @Override
            public void run() {
                ConnectionInformationWrapper.this.timerUpdate();
            }
        });
    }

    private void update() {
        try {
            this.setStale(true);
            Collection entries = this.provider.getStatistics();
            HashSet remainingList = new HashSet(this);
            for (StatisticEntry entry : entries) {
                InformationBean bean = this.beans.get(entry.getKey());
                if (bean == null) {
                    bean = new InformationBean();
                    bean.setLabel(entry.getLabel());
                    this.beans.put(entry.getKey(), bean);
                    this.add(bean);
                } else {
                    remainingList.remove(bean);
                }
                bean.update(entry);
            }
            this.removeAll(remainingList);
        }
        finally {
            this.setStale(false);
        }
    }
}

