/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.scada.core.ui.connection.login.Activator;
import org.eclipse.scada.core.ui.connection.login.LoginSession;
import org.eclipse.scada.core.ui.connection.login.Messages;
import org.eclipse.scada.core.ui.connection.login.SessionListener;

public abstract class SessionManager {
    protected final Set<SessionListener> listeners = new HashSet<SessionListener>();
    protected LoginSession session;
    private final Realm realm;

    protected SessionManager(Realm realm) {
        this.realm = realm;
    }

    public void addListener(SessionListener listener) {
        this.checkRealm();
        if (this.listeners.add(listener)) {
            listener.sessionChanged(this.session);
        }
    }

    protected void checkRealm() {
        Assert.isTrue((boolean)this.realm.isCurrent(), (String)Messages.SessionManager_ErrorRealm);
    }

    public void removeListener(SessionListener listener) {
        this.checkRealm();
        this.listeners.remove(listener);
    }

    protected void setSession(LoginSession session) {
        this.checkRealm();
        this.session = session;
        for (SessionListener listener : this.listeners) {
            listener.sessionChanged(session);
        }
    }

    protected void dispose() {
        this.checkRealm();
        for (SessionListener listener : this.listeners) {
            listener.sessionChanged(null);
        }
        this.listeners.clear();
    }

    public Realm getRealm() {
        return this.realm;
    }

    public static SessionManager getDefault() {
        return Activator.getDefault().getSessionManager();
    }

    public LoginSession getSession() {
        return this.session;
    }

    public boolean hasRole(String role) {
        if (role == null || role.isEmpty()) {
            return true;
        }
        LoginSession session = this.session;
        if (session == null) {
            return false;
        }
        return session.hasRole(role);
    }
}

