/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login.factory.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.utils.lang.Immutable;

@Immutable
public class LoginConnection {
    private final ConnectionInformation connectionInformation;
    private final Set<String> servicePids;
    private final Integer autoReconnectDelay;
    private final Integer priority;
    private final Mode mode;
    private final boolean useCallbacks;

    public LoginConnection(ConnectionInformation connectionInformation, Set<String> servicePids, Integer autoReconnectDelay, Integer priority, Mode mode, boolean useCallbacks) {
        this.connectionInformation = connectionInformation.clone();
        this.servicePids = servicePids != null ? new HashSet<String>(servicePids) : Collections.emptySet();
        this.autoReconnectDelay = autoReconnectDelay;
        this.priority = priority;
        this.mode = mode;
        this.useCallbacks = useCallbacks;
    }

    public boolean isUseCallbacks() {
        return this.useCallbacks;
    }

    public ConnectionInformation getConnectionInformation() {
        return this.connectionInformation.clone();
    }

    public Integer getAutoReconnectDelay() {
        return this.autoReconnectDelay;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Set<String> getServicePids() {
        return this.servicePids;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        NORMAL,
        OPTIONAL,
        LAZY;

    }
}

