/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.part.block;

import java.util.Calendar;
import java.util.HashMap;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.dataitem.details.Activator;
import org.eclipse.scada.da.client.dataitem.details.part.AbstractBaseDetailsPart;
import org.eclipse.scada.da.client.dataitem.details.part.block.Messages;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BlockDetailsPart
extends AbstractBaseDetailsPart {
    private static final String ATTR_ACTIVE = "org.eclipse.scada.da.master.common.block.active";
    private Label stateWidget;
    private Text userText;
    private Text timestampText;
    private Text reasonText;
    private Button blockButton;
    private Button unblockButton;

    @Override
    public void createPart(Composite parent) {
        super.createPart(parent);
        parent.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(parent, 0);
        label.setText(Messages.BlockDetailsPart_Label_State);
        this.stateWidget = new Label(parent, 0);
        this.stateWidget.setLayoutData((Object)new GridData(4, 4, false, false));
        this.stateWidget.setText(Messages.BlockDetailsPart_Label_State);
        this.stateWidget.setImage(Activator.getDefault().getImageRegistry().get("block.default"));
        label = new Label(parent, 0);
        label.setText(Messages.BlockDetailsPart_Label_User);
        this.userText = new Text(parent, 2056);
        this.userText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(parent, 0);
        label.setText(Messages.BlockDetailsPart_Label_Timestamp);
        this.timestampText = new Text(parent, 2056);
        this.timestampText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(parent, 0);
        label.setText(Messages.BlockDetailsPart_Label_Reason);
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.reasonText = new Text(parent, 2050);
        this.reasonText.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayout((Layout)new RowLayout(256));
        buttonBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.blockButton = new Button(buttonBar, 8);
        this.blockButton.setText(Messages.BlockDetailsPart_Text_Block);
        this.blockButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlockDetailsPart.this.block();
            }
        });
        this.unblockButton = new Button(buttonBar, 8);
        this.unblockButton.setText(Messages.BlockDetailsPart_Text_Unblock);
        this.unblockButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlockDetailsPart.this.unblock();
            }
        });
    }

    protected void unblock() {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put(ATTR_ACTIVE, Variant.FALSE);
        this.item.writeAtrtibutes(attributes, null, (CallbackHandler)this.makeDisplayCallback());
    }

    protected void block() {
        String text = this.reasonText.getText();
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put(ATTR_ACTIVE, Variant.TRUE);
        if (!text.isEmpty()) {
            attributes.put("org.eclipse.scada.da.master.common.block.note", Variant.valueOf((Object)text));
        }
        this.item.writeAtrtibutes(attributes, null, (CallbackHandler)this.makeDisplayCallback());
    }

    private DisplayCallbackHandler makeDisplayCallback() {
        return new DisplayCallbackHandler(this.shell, "Configure Block", "Confirmation required for configuring block");
    }

    protected boolean isAvailable() {
        return this.isForceActive() || this.hasAttribute(ATTR_ACTIVE);
    }

    protected boolean isActive() {
        return this.getBooleanAttribute(ATTR_ACTIVE);
    }

    @Override
    protected void update() {
        Image image;
        Variant user;
        Variant reason;
        Calendar timestamp;
        DataItemValue value = this.getValue();
        if (value != null) {
            timestamp = value.getAsTimestamp("org.eclipse.scada.da.master.common.block.timestamp");
            reason = (Variant)value.getAttributes().get("org.eclipse.scada.da.master.common.block.note");
            user = (Variant)value.getAttributes().get("org.eclipse.scada.da.master.common.block.user");
            image = Activator.getDefault().getImageRegistry().get(value.isBlocked() ? "block.locked" : "block.unlocked");
        } else {
            timestamp = null;
            reason = null;
            user = null;
            image = Activator.getDefault().getImageRegistry().get("block.default");
        }
        this.stateWidget.setImage(image);
        this.userText.setText(String.format(Messages.BlockDetailsPart_Format_User, user != null ? user.asString("") : Messages.BlockDetailsPart_NoneString));
        this.timestampText.setText(timestamp != null ? String.format(Messages.BlockDetailsPart_Format_Date, timestamp) : Messages.BlockDetailsPart_NoneString);
        if (reason != null) {
            this.reasonText.setText(reason.asString(""));
        } else {
            this.reasonText.setText("");
        }
        this.reasonText.setEnabled(this.isAvailable() && value != null && !this.isActive() && value.isConnected());
        this.blockButton.setEnabled(this.isAvailable() && value != null && !this.isActive() && value.isConnected());
        this.unblockButton.setEnabled(this.isAvailable() && value != null && this.isActive() && value.isConnected());
    }
}

