/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.summary.explorer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StaticStateInformation;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.da.client.DataItem;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.browser.DataItemEntry;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.browser.FolderEntry;
import org.eclipse.scada.da.ui.styles.DataItemValueStateExtractor;
import org.eclipse.scada.da.ui.summary.explorer.SummaryExplorerViewPart;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;

class TreeNode
extends AbstractPropertyChange
implements FolderListener {
    public static final String PROP_STATE = "state";
    public static final String PROP_STYLE = "style";
    private final ConnectionService connectionService;
    private final WritableSet groups;
    private final Map<String, TreeNode> nodes = new HashMap<String, TreeNode>();
    private final Location location;
    private final String name;
    private final Realm realm;
    private boolean subscribed;
    private StateInformation state = StaticStateInformation.EMPTY;
    private final String summaryItemName = "SUM.V";
    private DataItem item;
    private final Observer observer = new Observer(){

        @Override
        public void update(Observable o, final Object arg) {
            TreeNode.this.realm.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeNode.this.handleStateChange((DataItemValue)arg);
                }
            });
        }
    };
    private final StyleBlinker blinker;
    private StyleBlinker.CurrentStyle style = StyleBlinker.CurrentStyle.EMPTY;
    private final StateStyler styler;

    public TreeNode(Realm realm, ConnectionService connectionService, Location location, String name) {
        this.realm = realm;
        this.connectionService = connectionService;
        this.groups = new WritableSet(realm);
        this.location = location;
        this.name = name;
        this.blinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle style) {
                TreeNode.this.handleStyleChange(style);
            }
        };
        this.styler = new StateStyler((StyleHandler)this.blinker);
    }

    protected void handleStyleChange(final StyleBlinker.CurrentStyle style) {
        this.realm.asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeNode.this.setStyle(style);
            }
        });
    }

    protected void setStyle(StyleBlinker.CurrentStyle style) {
        this.style = style;
        this.firePropertyChange(PROP_STYLE, this.style, this.style);
    }

    public StyleBlinker.CurrentStyle getStyle() {
        return this.style;
    }

    protected void handleStateChange(DataItemValue value) {
        this.setState((StateInformation)new DataItemValueStateExtractor(value));
    }

    public void setState(StateInformation state) {
        this.state = state;
        this.firePropertyChange(PROP_STATE, this.state, this.state);
        this.styler.style(state);
    }

    public StateInformation getState() {
        return this.state;
    }

    public IObservable createObservable() {
        if (!this.subscribed) {
            this.subscribe();
        }
        return Observables.proxyObservableSet((IObservableSet)this.groups);
    }

    private void subscribe() {
        this.subscribed = true;
        this.connectionService.getFolderManager().addFolderListener((FolderListener)this, this.location);
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
        if (this.subscribed) {
            this.subscribed = false;
            this.connectionService.getFolderManager().removeFolderListener((FolderListener)this, this.location);
        }
        if (!this.groups.isDisposed()) {
            this.clearChilds();
            this.groups.dispose();
        }
        this.unsubscribeItem();
        this.styler.dispose();
        this.blinker.dispose();
    }

    protected void clearChilds() {
        this.groups.clear();
        for (TreeNode node : this.nodes.values()) {
            node.dispose();
        }
        this.nodes.clear();
    }

    public void folderChanged(final Collection<Entry> added, final Collection<String> removed, final boolean full) {
        SummaryExplorerViewPart.logger.debug("Folder change - {} - added: {}, removed: {}, full: {}", new Object[]{this.location, added, removed, full});
        if (!this.groups.isDisposed()) {
            this.groups.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeNode.this.performChange(added, removed, full);
                }
            });
        }
    }

    protected void performChange(Collection<Entry> added, Collection<String> removed, boolean full) {
        TreeNode node;
        SummaryExplorerViewPart.logger.debug("perform change - {} - added: {}, removed: {}, full: {}", new Object[]{this.location, added, removed, full});
        if (this.groups.isDisposed()) {
            return;
        }
        if (full) {
            this.clearChilds();
        }
        if (added != null) {
            for (Entry entry : added) {
                String name;
                if (entry instanceof FolderEntry) {
                    node = new TreeNode(this.realm, this.connectionService, new Location(this.location, entry.getName()), entry.getName());
                    this.groups.add((Object)node);
                    this.nodes.put(entry.getName(), node);
                    continue;
                }
                if (!(entry instanceof DataItemEntry) || !"SUM.V".equals(name = entry.getName())) continue;
                this.subscribeItem(((DataItemEntry)entry).getId());
            }
        }
        if (removed != null) {
            for (String key : removed) {
                node = this.nodes.remove(key);
                if (node != null) {
                    this.groups.remove((Object)node);
                    node.dispose();
                }
                if (!"SUM.V".equals(key)) continue;
                this.unsubscribeItem();
            }
        }
    }

    private void unsubscribeItem() {
        if (this.item != null) {
            this.item.unregister();
            this.item = null;
        }
    }

    private void subscribeItem(String id) {
        this.unsubscribeItem();
        this.item = new DataItem(id);
        this.item.addObserver(this.observer);
        this.item.register(this.connectionService.getItemManager());
    }
}

