/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.jobs;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scada.ca.client.Connection;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.ui.Activator;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.ConnectionRequest;
import org.eclipse.scada.core.connection.provider.ConnectionRequestTracker;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class DiffJob
extends UIJob {
    private final List<DiffEntry> diffEntries;
    private final String connectionUri;
    private final AtomicReference<Thread> runner = new AtomicReference();
    private final ConnectionService connectionService;

    public DiffJob(String jobName, String connectionUri, DiffEntry diffEntry) {
        super(jobName);
        this.connectionUri = connectionUri;
        this.connectionService = null;
        this.diffEntries = Arrays.asList(diffEntry);
    }

    public DiffJob(String jobName, String connectionUri, List<DiffEntry> diffEntries) {
        super(jobName);
        this.connectionUri = connectionUri;
        this.connectionService = null;
        this.diffEntries = diffEntries;
    }

    public DiffJob(String jobName, ConnectionService connectionService, List<DiffEntry> diffEntries) {
        super(jobName);
        this.connectionUri = null;
        this.connectionService = connectionService;
        this.diffEntries = diffEntries;
    }

    public DiffJob(String jobName, ConnectionService connectionService, DiffEntry entry) {
        this(jobName, connectionService, Arrays.asList(entry));
    }

    protected void canceling() {
        Thread thread = this.runner.getAndSet(null);
        thread.interrupt();
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (this.connectionService != null) {
            try {
                this.runWithService(this.connectionService);
            }
            catch (Exception e) {
                return new Status(4, "org.eclipse.scada.ca.ui", "Failed to save data", (Throwable)e);
            }
            return Status.OK_STATUS;
        }
        ConnectionInformation connectionInformation = ConnectionInformation.fromURI((String)this.connectionUri);
        ConnectionRequestTracker tracker = new ConnectionRequestTracker(Activator.getBundleContext(), new ConnectionRequest(null, connectionInformation, Integer.valueOf(10000), true), null);
        try {
            this.runner.set(Thread.currentThread());
            tracker.open();
            tracker.waitForService(0L);
            ConnectionService connectionService = tracker.getService();
            this.runWithService(connectionService);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (InterruptedException interruptedException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.scada.ca.ui", "Failed to save data", (Throwable)e);
            return status;
        }
        finally {
            this.runner.set(null);
            tracker.close();
        }
    }

    private void runWithService(ConnectionService connectionService) {
        Connection connection = (Connection)connectionService.getConnection();
        connection.applyDiff(this.diffEntries, null, (CallbackHandler)new DisplayCallbackHandler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Apply diff", "Confirmation on applying diff required"));
    }
}

