/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login.factory;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.scada.core.ui.connection.login.LoginHandler;
import org.eclipse.scada.core.ui.connection.login.StateListener;
import org.osgi.framework.BundleContext;

public class MultiLoginHandler
implements LoginHandler {
    private final ArrayList<LoginHandler> handler;
    private StateListener stateListener;

    public MultiLoginHandler(Collection<LoginHandler> handler) {
        this.handler = new ArrayList<LoginHandler>(handler);
    }

    @Override
    public void setStateListener(StateListener stateListener) {
        this.stateListener = stateListener;
        for (LoginHandler handler : this.handler) {
            handler.setStateListener(stateListener);
        }
    }

    @Override
    public void startLogin() {
        if (this.handler.isEmpty()) {
            StateListener listener = this.stateListener;
            if (listener != null) {
                listener.stateChanged(null, null, null);
            }
        } else {
            for (LoginHandler handler : this.handler) {
                handler.startLogin();
            }
        }
    }

    @Override
    public void register(BundleContext context) {
        for (LoginHandler handler : this.handler) {
            handler.register(context);
        }
    }

    @Override
    public void dispose() {
        for (LoginHandler handler : this.handler) {
            handler.dispose();
        }
    }

    @Override
    public boolean isOk() {
        for (LoginHandler handler : this.handler) {
            if (handler.isOk()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isComplete() {
        for (LoginHandler handler : this.handler) {
            if (handler.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasRole(String role) {
        for (LoginHandler handler : this.handler) {
            if (!handler.hasRole(role)) continue;
            return true;
        }
        return false;
    }
}

