/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.controller.actions;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.ScaleAction;
import org.eclipse.scada.ui.chart.model.XAxisController;
import org.eclipse.scada.ui.chart.viewer.ChartContext;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.controller.ControllerManager;
import org.eclipse.scada.ui.chart.viewer.controller.actions.AbstractXAxisController;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ScaleActionController
extends AbstractXAxisController {
    private Button button;
    private long milliseconds;
    private IValueChangeListener layoutListener;
    private IObservableValue labelProperty;

    public ScaleActionController(ControllerManager controllerManager, ChartContext chartContext, ScaleAction controller) {
        super(controllerManager.getContext(), chartContext, (XAxisController)controller);
        DataBindingContext ctx = controllerManager.getContext();
        final Composite space = chartContext.getExtensionSpaceProvider().getExtensionSpace();
        if (space != null) {
            this.button = new Button(space, 8);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ScaleActionController.this.action();
                }
            });
            this.addBinding(ctx.bindValue(PojoObservables.observeValue((Object)this, (String)"milliseconds"), EMFObservables.observeValue((EObject)controller, (EStructuralFeature)ChartPackage.Literals.SCALE_ACTION__TIMESPAN)));
            this.addBinding(ctx.bindValue((IObservableValue)SWTObservables.observeText((Control)this.button), EMFObservables.observeValue((EObject)controller, (EStructuralFeature)ChartPackage.Literals.SCALE_ACTION__LABEL)));
            this.addBinding(ctx.bindValue((IObservableValue)SWTObservables.observeTooltipText((Control)this.button), EMFObservables.observeValue((EObject)controller, (EStructuralFeature)ChartPackage.Literals.SCALE_ACTION__DESCRIPTION)));
            this.layoutListener = new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    space.layout();
                }
            };
            this.labelProperty = EMFObservables.observeValue((EObject)controller, (EStructuralFeature)ChartPackage.Literals.SCALE_ACTION__LABEL);
            this.labelProperty.addValueChangeListener(this.layoutListener);
            space.layout();
        } else {
            this.button = null;
        }
    }

    protected void action() {
        for (XAxisViewer viewer : this.getCurrentViewers()) {
            viewer.getAxis().setByTimespan(this.milliseconds, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void dispose() {
        if (this.button != null) {
            this.button.dispose();
            this.button = null;
        }
        if (this.labelProperty != null) {
            if (this.layoutListener != null) {
                this.labelProperty.removeValueChangeListener(this.layoutListener);
            }
            this.labelProperty.dispose();
            this.labelProperty = null;
        }
        super.dispose();
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }
}

