/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.chart.draw2d;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DisplayRealm;
import org.eclipse.scada.vi.ui.chart.draw2d.ChartFigure;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class FigureRenderer
extends ChartRenderer {
    private final ChartFigure chartFigure;
    private final FigureListenerImpl figureListener;
    private final Realm realm;
    private final Map<ChartMouseListener, MouseListener> mouseListenerMap = new HashMap<ChartMouseListener, MouseListener>();
    private final Map<ChartMouseMoveListener, MouseMotionListener> mouseMoveListenerMap = new HashMap<ChartMouseMoveListener, MouseMotionListener>();

    public FigureRenderer(ChartFigure chartFigure, ResourceManager resourceManager) {
        super(resourceManager);
        this.realm = new DisplayRealm(Display.getCurrent());
        this.chartFigure = chartFigure;
        this.figureListener = new FigureListenerImpl();
        this.chartFigure.addFigureListener(this.figureListener);
    }

    public void dispose() {
        this.chartFigure.removeFigureListener(this.figureListener);
        super.dispose();
    }

    public void handleResize() {
        this.resizeAll(this.getClientArea());
    }

    protected void redraw() {
        this.chartFigure.getUpdateManager().addDirtyRegion((IFigure)this.chartFigure, this.chartFigure.getBounds());
    }

    public Rectangle getClientArea() {
        org.eclipse.draw2d.geometry.Rectangle rect = this.chartFigure.getClientArea();
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void addMouseListener(final ChartMouseListener mouseListener) {
        this.removeMouseListener(mouseListener);
        MouseListener proxyListener = new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
                mouseListener.onMouseDoubleClick(FigureRenderer.this.convertEvent(me));
            }

            public void mousePressed(MouseEvent me) {
                mouseListener.onMouseDown(FigureRenderer.this.convertEvent(me));
            }

            public void mouseReleased(MouseEvent me) {
                mouseListener.onMouseUp(FigureRenderer.this.convertEvent(me));
            }
        };
        this.mouseListenerMap.put(mouseListener, proxyListener);
        this.chartFigure.addMouseListener(proxyListener);
    }

    public void removeMouseListener(ChartMouseListener mouseListener) {
        MouseListener proxyListener = this.mouseListenerMap.remove(mouseListener);
        if (proxyListener != null) {
            this.chartFigure.removeMouseListener(proxyListener);
        }
    }

    public void addMouseMoveListener(final ChartMouseMoveListener mouseMoveListener) {
        this.removeMouseMoveListener(mouseMoveListener);
        MouseMotionListener proxyListener = new MouseMotionListener(){

            public void mouseMoved(MouseEvent me) {
                mouseMoveListener.onMouseMove(FigureRenderer.this.convertEvent(me));
            }

            public void mouseHover(MouseEvent me) {
                mouseMoveListener.onMouseMove(FigureRenderer.this.convertEvent(me));
            }

            public void mouseExited(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
            }

            public void mouseDragged(MouseEvent me) {
                mouseMoveListener.onMouseMove(FigureRenderer.this.convertEvent(me));
            }
        };
        this.mouseMoveListenerMap.put(mouseMoveListener, proxyListener);
        this.chartFigure.addMouseMotionListener(proxyListener);
    }

    public void removeMouseMoveListener(ChartMouseMoveListener mouseMoveListener) {
        MouseMotionListener proxyListener = this.mouseMoveListenerMap.remove(mouseMoveListener);
        if (proxyListener != null) {
            this.chartFigure.removeMouseMotionListener(proxyListener);
        }
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
    }

    public Realm getRealm() {
        return this.realm;
    }

    private ChartMouseListener.MouseState convertEvent(MouseEvent me) {
        ChartMouseListener.MouseState state = new ChartMouseListener.MouseState();
        state.button = me.button;
        state.x = me.x;
        state.y = me.y;
        state.state = me.getState();
        return state;
    }

    public class FigureListenerImpl
    implements FigureListener {
        public void figureMoved(IFigure source) {
            FigureRenderer.this.handleResize();
        }
    }
}

