/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.data;

import java.util.ArrayList;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.core.ui.connection.data.Messages;
import org.eclipse.scada.utils.str.StringHelper;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PropertySourceWrapper
implements IPropertySource {
    private static final String CAT_SESSION_PROPERTIES = Messages.PropertySourceWrapper_CatSessionProperties;
    private static final String CAT_CONNECTION_STATE = Messages.PropertySourceWrapper_CatConnectionState;
    private static final String CAT_CONNECTION_SERVICE = Messages.PropertySourceWrapper_CatConnectionService;
    private static final String CAT_CONNECTION_INFORMATION = Messages.PropertySourceWrapper_CatConnectionInformation;
    private final ConnectionHolder connectionHolder;

    public PropertySourceWrapper(ConnectionHolder connectionHolder) {
        this.connectionHolder = connectionHolder;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor pd = new PropertyDescriptor((Object)Properties.URI, Messages.PropertySourceWrapper_UriName);
        pd.setCategory(CAT_CONNECTION_INFORMATION);
        pd.setDescription(Messages.PropertySourceWrapper_UriDesc);
        properties.add(pd);
        pd = new PropertyDescriptor((Object)Properties.ID, Messages.PropertySourceWrapper_IdName);
        pd.setCategory(CAT_CONNECTION_INFORMATION);
        pd.setDescription(Messages.PropertySourceWrapper_IdDesc);
        properties.add(pd);
        pd = new PropertyDescriptor((Object)Properties.INTERFACES, Messages.PropertySourceWrapper_InterfacesName);
        pd.setCategory(CAT_CONNECTION_SERVICE);
        pd.setDescription(Messages.PropertySourceWrapper_InterfacesDesc);
        properties.add(pd);
        pd = new PropertyDescriptor((Object)Properties.STATE, Messages.PropertySourceWrapper_StateName);
        pd.setCategory(CAT_CONNECTION_STATE);
        pd.setDescription(Messages.PropertySourceWrapper_StateDesc);
        properties.add(pd);
        Connection connection = this.getConnection();
        if (connection != null) {
            for (String key : connection.getSessionProperties().keySet()) {
                PropertyDescriptor pd2 = new PropertyDescriptor((Object)new SessionPropertyDescriptor(key), key);
                pd2.setCategory(CAT_SESSION_PROPERTIES);
                properties.add(pd2);
            }
        }
        return properties.toArray(new IPropertyDescriptor[0]);
    }

    private Connection getConnection() {
        if (this.connectionHolder == null) {
            return null;
        }
        if (this.connectionHolder.getConnectionService() == null) {
            return null;
        }
        return this.connectionHolder.getConnectionService().getConnection();
    }

    public Object getPropertyValue(Object id) {
        if (Properties.URI.equals(id)) {
            return this.connectionHolder.getConnectionInformation().getConnectionInformation().toMaskedString();
        }
        if (Properties.ID.equals(id)) {
            return this.connectionHolder.getConnectionInformation().getServiceId();
        }
        ConnectionService service = this.connectionHolder.getConnectionService();
        if (service == null) {
            return null;
        }
        if (Properties.INTERFACES.equals(id)) {
            return String.format(Messages.PropertySourceWrapper_StateFormat, StringHelper.join((Object[])service.getSupportedInterfaces(), (String)Messages.PropertySourceWrapper_StateFormatDelim));
        }
        Connection connection = service.getConnection();
        if (connection == null) {
            return connection;
        }
        if (Properties.STATE.equals(id)) {
            return connection.getState();
        }
        if (id instanceof SessionPropertyDescriptor) {
            return connection.getSessionProperties().get(((SessionPropertyDescriptor)id).getKey());
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private static enum Properties {
        URI,
        ID,
        INTERFACES,
        STATE;

    }

    private static class SessionPropertyDescriptor {
        private final String key;

        public SessionPropertyDescriptor(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

