/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.ConnectionStore;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.core.ui.connection.wizards.AddConnectionWizardPage1;
import org.eclipse.scada.core.ui.connection.wizards.SelectConnectionStorePage;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddConnectionWizard
extends Wizard
implements INewWizard {
    private static final Logger logger = LoggerFactory.getLogger(AddConnectionWizard.class);
    private AddConnectionWizardPage1 entryPage;
    private ConnectionStore store;
    private ConnectionDescriptor preset;
    private SelectConnectionStorePage storePage;

    protected boolean isUpdateMode() {
        return false;
    }

    public boolean performFinish() {
        ConnectionDescriptor connectionInformation = this.entryPage.getConnectionInformation();
        ConnectionStore store = this.getStore();
        try {
            if (connectionInformation != null) {
                if (this.isUpdateMode()) {
                    store.update(this.preset, connectionInformation);
                } else {
                    store.add(connectionInformation);
                }
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus(), 4);
            return false;
        }
        return connectionInformation != null;
    }

    protected ConnectionStore getStore() {
        ConnectionStore store = this.storePage != null ? this.storePage.getStore() : this.store;
        return store;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object o = selection.getFirstElement();
        if (o == null) {
            return;
        }
        this.store = (ConnectionStore)AdapterHelper.adapt((Object)o, ConnectionStore.class);
        logger.info("Store is: {}", (Object)this.store);
        ConnectionHolder holder = (ConnectionHolder)((Object)AdapterHelper.adapt((Object)o, ConnectionHolder.class));
        if (holder != null) {
            if (this.store == null) {
                this.store = (ConnectionStore)AdapterHelper.adapt((Object)holder.getDiscoverer(), ConnectionStore.class);
            }
            this.preset = holder.getConnectionInformation();
        }
        logger.info("Preset is: {}", (Object)this.preset);
    }

    public boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        if (this.getStore() == null) {
            return false;
        }
        return this.entryPage.getConnectionInformation() != null;
    }

    public void addPages() {
        super.addPages();
        if (!this.isUpdateMode() && this.store == null) {
            this.storePage = new SelectConnectionStorePage();
            this.addPage((IWizardPage)this.storePage);
        }
        this.entryPage = new AddConnectionWizardPage1(this.preset);
        this.addPage((IWizardPage)this.entryPage);
    }
}

