/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.wizards;

import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.core.ui.connection.Activator;
import org.eclipse.scada.core.ui.connection.ConnectionStore;
import org.eclipse.scada.core.ui.connection.views.ConnectionLabelProvider;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.swt.widgets.Composite;

public class SelectConnectionStorePage
extends WizardPage {
    private TableViewer tableViewer;
    private IObservableSet stores;

    protected SelectConnectionStorePage() {
        super("selectConnectionStore");
        this.setTitle("Select store");
        this.setDescription("The connection will be added to the selected store");
    }

    public void createControl(Composite parent) {
        this.stores = Activator.getDefault().getStoresSet();
        this.tableViewer = new TableViewer(parent);
        this.setControl(this.tableViewer.getControl());
        this.tableViewer.setContentProvider((IContentProvider)new ObservableSetContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ConnectionLabelProvider());
        this.tableViewer.setInput((Object)this.stores);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectConnectionStorePage.this.update();
            }
        });
        this.update();
    }

    private void update() {
        ConnectionStore store = this.getStore();
        if (store == null) {
            this.setMessage("A connection store has to be selected to which the connection should be added", 1);
        } else {
            this.setMessage(null);
        }
        this.setPageComplete(store != null);
    }

    public ConnectionStore getStore() {
        return (ConnectionStore)SelectionHelper.first((ISelection)this.tableViewer.getSelection(), ConnectionStore.class);
    }
}

