/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.scada.sec.ui.providers.KeyInformation;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyInstanceManager {
    private static final Logger logger = LoggerFactory.getLogger(StatusListener.class);
    private static Map<Display, KeyInstanceManager> instanceMap = new ConcurrentHashMap<Display, KeyInstanceManager>();
    private final Display display;
    private final Set<StatusListener> statusListeners = new HashSet<StatusListener>();
    private KeyInformation defaultKey;
    private Date validUntil;
    private boolean disposed;

    private KeyInstanceManager(Display display) {
        this.display = display;
    }

    public void setDefaultKey(KeyInformation key, Integer keyTimeout) {
        this.checkDisplay();
        this.defaultKey = key;
        if (keyTimeout != null && keyTimeout > 0) {
            this.validUntil = new Date(System.currentTimeMillis() + (long)keyTimeout.intValue());
            this.display.timerExec(keyTimeout.intValue(), new Runnable(){

                @Override
                public void run() {
                    KeyInstanceManager.this.checkClearKey();
                }
            });
        } else {
            this.validUntil = null;
        }
        this.fireUpdate(key, this.validUntil);
    }

    protected void checkClearKey() {
        if (this.validUntil == null || this.disposed) {
            return;
        }
        if (new Date().after(this.validUntil)) {
            logger.debug("Clearing default key after period");
            this.clearDefaultKey();
        }
    }

    private void checkDisplay() {
        if (Display.getCurrent() != this.display) {
            SWT.error((int)22);
        }
    }

    private void fireUpdate(final KeyInformation key, final Date validUntil) {
        for (final StatusListener listener : this.statusListeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.defaultKeyChanged(key, validUntil);
                }
            });
        }
    }

    public void clearDefaultKey() {
        this.setDefaultKey(null, null);
    }

    public KeyInformation getDefaultKey() {
        this.checkDisplay();
        return this.defaultKey;
    }

    private void dispose() {
        this.disposed = true;
        this.statusListeners.clear();
    }

    public void addStatusListener(StatusListener statusListener) {
        this.statusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.statusListeners.remove(statusListener);
    }

    public static KeyInstanceManager getInstance(final Display display) {
        KeyInstanceManager mgr;
        if (display == null) {
            SWT.error((int)4);
        }
        if (Display.getCurrent() != display) {
            SWT.error((int)22);
        }
        if (display.isDisposed()) {
            SWT.error((int)45);
        }
        if ((mgr = instanceMap.get(display)) != null) {
            return mgr;
        }
        mgr = new KeyInstanceManager(display);
        instanceMap.put(display, mgr);
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                KeyInstanceManager.disposeDisplay(display);
            }
        });
        return mgr;
    }

    protected static void disposeDisplay(Display display) {
        KeyInstanceManager mgr = instanceMap.remove(display);
        if (mgr != null) {
            mgr.dispose();
        }
    }

    public static interface StatusListener {
        public void defaultKeyChanged(KeyInformation var1, Date var2);
    }
}

