/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.sec.ui.providers.KeyInformation;
import org.eclipse.scada.sec.ui.providers.KeyInstanceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.services.IServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyInstanceProvider
extends AbstractSourceProvider
implements KeyInstanceManager.StatusListener {
    private static final Logger logger = LoggerFactory.getLogger(KeyInstanceProvider.class);
    private static final String VAR_DEFAULT_KEY = "org.eclipse.scada.sec.ui.providers.KeyInstance.defaultKey";
    private static final String VAR_IS_DEFAULT_KEY = "org.eclipse.scada.sec.ui.providers.KeyInstance.isDefaultKey";
    private KeyInstanceManager mgr;

    public void initialize(IServiceLocator locator) {
        super.initialize(locator);
        this.mgr = KeyInstanceManager.getInstance(Display.getCurrent());
        this.mgr.addStatusListener(this);
    }

    public void dispose() {
        this.mgr.removeStatusListener(this);
    }

    public Map getCurrentState() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(VAR_DEFAULT_KEY, this.mgr.getDefaultKey());
        result.put(VAR_IS_DEFAULT_KEY, this.mgr.getDefaultKey() != null);
        return result;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{VAR_DEFAULT_KEY};
    }

    @Override
    public void defaultKeyChanged(KeyInformation key, Date validUntil) {
        logger.debug("Default key changed: {} -> {}", (Object)key, (Object)validUntil);
        this.fireSourceChanged(0, this.getCurrentState());
    }
}

