/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.signalgenerator.page;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scada.da.ui.client.signalgenerator.Activator;
import org.eclipse.scada.da.ui.client.signalgenerator.SimulationTarget;
import org.eclipse.scada.da.ui.client.signalgenerator.page.GeneratorPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractStepGeneratorPage
implements GeneratorPage {
    private long lastTimestamp;
    protected Display display;
    private volatile boolean running;
    private long period = 250L;
    private final int tickDelay = 100;
    protected SimulationTarget target;

    protected abstract void step();

    @Override
    public void dispose() {
        this.stop();
    }

    protected void setPeriod(long period) {
        this.period = period;
    }

    @Override
    public void createPage(Composite parent) {
        this.display = parent.getDisplay();
    }

    @Override
    public void start() {
        this.lastTimestamp = 0L;
        this.running = true;
        this.setTimer();
    }

    private void setTimer() {
        this.display.timerExec(100, new Runnable(){

            @Override
            public void run() {
                AbstractStepGeneratorPage.this.tick();
            }
        });
    }

    @Override
    public void stop() {
        this.running = false;
    }

    private void tick() {
        if (!this.running) {
            return;
        }
        long now = System.currentTimeMillis();
        try {
            try {
                if (now - this.lastTimestamp > this.period) {
                    this.lastTimestamp = now;
                    this.step();
                }
            }
            catch (Throwable e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scada.da.client.signalGenerator", "Failed to step", e));
                this.setTimer();
            }
        }
        finally {
            this.setTimer();
        }
    }

    @Override
    public void setTarget(SimulationTarget target) {
        this.target = target;
    }
}

