/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.signalgenerator.page;

import java.util.Random;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.ui.client.signalgenerator.page.Messages;

public enum AnalogType {
    SINE(Messages.getString("AnalogType.TypeSine.label")){

        @Override
        public Variant generate(double timeIndex, double min, double max, double period) {
            double val = Math.sin(timeIndex * 1.0 / period);
            val = AnalogType.scale(min, max, val);
            return Variant.valueOf((double)val);
        }
    }
    ,
    COSINE(Messages.getString("AnalogType.TypeCosine.label")){

        @Override
        public Variant generate(double timeIndex, double min, double max, double period) {
            double val = Math.cos(timeIndex * 1.0 / period);
            val = AnalogType.scale(min, max, val);
            return Variant.valueOf((double)val);
        }
    }
    ,
    RANDOM_NORMAL(Messages.getString("AnalogType.TypeRandom.label")){
        private final Random r = new Random();

        @Override
        public Variant generate(double timeIndex, double min, double max, double period) {
            double range = max - min;
            return Variant.valueOf((double)(this.r.nextDouble() * range + min));
        }
    }
    ,
    RANDOM_GAUSSIAN(Messages.getString("AnalogType.TypeRandomGaussian.label")){
        private final Random r = new Random();

        @Override
        public Variant generate(double timeIndex, double min, double max, double period) {
            return Variant.valueOf((double)AnalogType.scale(min, max, this.r.nextGaussian() / 2.0));
        }
    }
    ,
    TRIANGLE(Messages.getString("AnalogType.TypeTriangle.label")){

        @Override
        public Variant generate(double timeIndex, double min, double max, double period) {
            double range = max - min;
            double val = timeIndex / period % range + min;
            return Variant.valueOf((double)val);
        }
    }
    ,
    SQUARE(Messages.getString("AnalogType.TypeSquare.label")){

        @Override
        public Variant generate(double timeIndex, double min, double max, double period) {
            double val = (long)timeIndex / (long)period % 2L;
            return Variant.valueOf((double)(val == 0.0 ? min : max));
        }
    };

    private final String label;

    public abstract Variant generate(double var1, double var3, double var5, double var7);

    private static double scale(double min, double max, double val) {
        double range = (max - min) / 2.0;
        double offset = min + range;
        val = val * range + offset;
        return val;
    }

    private AnalogType(String label) {
        this.label = label;
    }

    public String toLabel() {
        return this.label;
    }

    /* synthetic */ AnalogType(String string, int n, String string2, AnalogType analogType) {
        this(string2);
    }
}

