/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.discoverer.prefs;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.ui.connection.AbstractConnectionDiscoverer;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.ConnectionStore;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPreferencesDiscoverer
extends AbstractConnectionDiscoverer
implements ConnectionStore {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPreferencesDiscoverer.class);
    private static final String PREF_NAME = "connection";
    private PreferenceChangeListener listener;

    protected abstract Preferences getNode();

    public AbstractPreferencesDiscoverer() {
        this.initialize();
    }

    protected void initialize() {
        this.loadAll();
        this.listener = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (AbstractPreferencesDiscoverer.PREF_NAME.equals(evt.getKey())) {
                    AbstractPreferencesDiscoverer.this.refresh();
                }
            }
        };
        this.getNode().addPreferenceChangeListener(this.listener);
    }

    public synchronized void dispose() {
        this.getNode().removePreferenceChangeListener(this.listener);
        super.dispose();
    }

    private void loadAll() {
        try {
            HashSet<ConnectionDescriptor> result = new HashSet<ConnectionDescriptor>();
            String[] stringArray = this.getNode().childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                ConnectionDescriptor cd = this.loadNode(uri, this.getNode().node(uri));
                if (cd != null) {
                    result.add(cd);
                }
                ++n2;
            }
            this.setConnections(result);
        }
        catch (BackingStoreException e) {
            logger.warn("Failed to get children", (Throwable)e);
        }
    }

    private ConnectionDescriptor loadNode(String uriEncoded, Preferences node) {
        try {
            String uri = URLDecoder.decode(uriEncoded, "UTF-8");
            String serviceId = node.get("serviceId", null);
            String description = node.get("description", null);
            return new ConnectionDescriptor(ConnectionInformation.fromURI((String)uri), serviceId, description);
        }
        catch (Exception e) {
            logger.warn("Failed to decode node", (Throwable)e);
            return null;
        }
    }

    protected void refresh() {
        this.loadAll();
    }

    public void add(ConnectionDescriptor connectionInformation) throws CoreException {
        try {
            if (this.addConnection(connectionInformation)) {
                this.performAdd(connectionInformation);
            }
        }
        catch (Exception e) {
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.core.ui.connection.discoverer.prefs", (Throwable)e));
        }
    }

    private void performAdd(ConnectionDescriptor connectionInformation) throws Exception {
        String uri = URLEncoder.encode(connectionInformation.getConnectionInformation().toString(), "UTF-8");
        Preferences node = this.getNode();
        Preferences child = node.node(uri);
        this.storeValue(child, "description", connectionInformation.getDescription());
        this.storeValue(child, "serviceId", connectionInformation.getServiceId());
        this.getNode().flush();
    }

    protected void storeValue(Preferences node, String key, String value) {
        if (value != null) {
            node.put(key, value);
        } else {
            node.remove(key);
        }
    }

    public void remove(ConnectionDescriptor connectionInformation) throws CoreException {
        try {
            if (this.removeConnection(connectionInformation)) {
                String uri = URLEncoder.encode(connectionInformation.getConnectionInformation().toString(), "UTF-8");
                if (this.getNode().nodeExists(uri)) {
                    Preferences node = this.getNode().node(uri);
                    node.removeNode();
                    this.getNode().flush();
                    this.fireDiscoveryUpdate(null, new ConnectionDescriptor[]{connectionInformation});
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.core.ui.connection.discoverer.prefs", (Throwable)e));
        }
    }

    public void update(ConnectionDescriptor original, ConnectionDescriptor updated) throws CoreException {
        this.remove(original);
        this.add(updated);
    }
}

