/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.connection.navigator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.scada.ca.ui.connection.data.ConfigurationInformationBean;
import org.eclipse.scada.ca.ui.connection.data.FactoryInformationBean;
import org.eclipse.scada.ui.databinding.CommonListeningLabelProvider;
import org.eclipse.scada.ui.databinding.StyledViewerLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionLabelProvider
extends CommonListeningLabelProvider
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLabelProvider.class);
    private final ResourceManager resource = new LocalResourceManager(JFaceResources.getResources());

    public ConnectionLabelProvider() {
        super("org.eclipse.scada.ca.ui.connection.provider");
    }

    public void dispose() {
        this.resource.dispose();
        super.dispose();
    }

    public void updateLabel(StyledViewerLabel label, Object element) {
        logger.debug("Update label: {}", element);
        if (element instanceof FactoryInformationBean) {
            FactoryInformationBean entry = (FactoryInformationBean)((Object)element);
            StyledString string = new StyledString(entry.getFactoryInformation().getId());
            string.append(String.format(" [%s]", entry.getFactoryInformation().getState()), StyledString.DECORATIONS_STYLER);
            if (entry.getConfigurations() != null && entry.getState() == FactoryInformationBean.State.COMPLETE) {
                string.append(String.format(" (%s)", entry.getConfigurations().size()), StyledString.COUNTER_STYLER);
            }
            label.setStyledText(string);
        } else if (element instanceof ConfigurationInformationBean) {
            ConfigurationInformationBean entry = (ConfigurationInformationBean)element;
            StyledString string = new StyledString(entry.getConfigurationInformation().getId());
            string.append(String.format(" [%s]", entry.getConfigurationInformation().getState()), StyledString.DECORATIONS_STYLER);
            label.setStyledText(string);
        } else {
            super.updateLabel(label, element);
        }
    }

    public String getDescription(Object element) {
        if (element instanceof FactoryInformationBean) {
            return ((FactoryInformationBean)((Object)element)).getFactoryInformation().getDescription();
        }
        return super.getDescription(element);
    }

    protected void addListenerTo(Object next) {
        super.addListenerTo(next);
        if (next instanceof FactoryInformationBean) {
            ((FactoryInformationBean)((Object)next)).addPropertyChangeListener(this);
        }
    }

    protected void removeListenerFrom(Object next) {
        if (next instanceof FactoryInformationBean) {
            ((FactoryInformationBean)((Object)next)).removePropertyChangeListener(this);
        }
        super.removeListenerFrom(next);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireChangeEvent(Arrays.asList(evt.getSource()));
    }
}

