/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scada.vi.details.DetailView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailViewManager {
    private static final Logger logger = LoggerFactory.getLogger(DetailViewManager.class);
    private static final String EXTP_DETAIL_VIEW = "org.eclipse.scada.vi.details.detailView";

    public static DetailView openView(String id, Map<String, String> properties) throws CoreException {
        logger.info("Searching view: {}", (Object)id);
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_DETAIL_VIEW);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            String cfgId = ele.getAttribute("id");
            logger.debug("Checking: {}", (Object)cfgId);
            if (cfgId != null && cfgId.equals(id)) {
                return DetailViewManager.createDetailView(id, ele, properties);
            }
            ++n2;
        }
        return null;
    }

    private static DetailView createDetailView(String id, IConfigurationElement ele, Map<String, String> properties) throws CoreException {
        Object o = ele.createExecutableExtension("class");
        if (o instanceof DetailView) {
            DetailView view = (DetailView)o;
            return view;
        }
        logger.warn("View created object of type: " + o);
        return null;
    }
}

