/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.handler;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.scada.ui.databinding.AbstractSelectionHandler;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.vi.details.DetailViewDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class ShowDetailDialog
extends AbstractSelectionHandler {
    private final boolean useWaitShell = !Boolean.getBoolean("org.eclipse.scada.vi.details.handler.disableWaitShell");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String detailViewId = event.getParameter("org.eclipse.scada.vi.details.showDetailDialog.id");
        Map parameters = (Map)event.getObjectParameterForExecution("org.eclipse.scada.vi.details.showDetailDialog.parameters");
        try {
            if (this.useWaitShell) {
                this.openWithWaitShell(this.getShell(), detailViewId, parameters);
            } else {
                this.open(this.getShell(), detailViewId, parameters);
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.vi.details", (String)"Failed to open detail view", (Throwable)e), 2);
        }
        return null;
    }

    protected void openWithWaitShell(Shell parentShell, String detailViewId, Map<String, String> parameters) {
        Shell waitShell = new Shell(parentShell, 34816);
        waitShell.setLayout((Layout)new FillLayout());
        Label label = new Label((Composite)waitShell, 0);
        label.setText("Opening view\u2026");
        waitShell.pack();
        waitShell.open();
        waitShell.getDisplay().update();
        try {
            this.open(parentShell, detailViewId, parameters);
        }
        finally {
            waitShell.close();
        }
    }

    protected void open(Shell parentShell, String detailViewId, Map<String, String> parameters) {
        DetailViewDialog dlg = new DetailViewDialog(parentShell, detailViewId, parameters);
        dlg.open();
    }
}

