/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.styles;

import org.eclipse.scada.core.ui.styles.Activator;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StyleGenerator;
import org.eclipse.scada.core.ui.styles.StyleHandler;

public class StateStyler {
    private final StyleGenerator generator;
    private StateInformation currentState;
    private final StyleHandler handler;
    private final StyleGenerator.GeneratorListener listener = new StyleGenerator.GeneratorListener(){

        @Override
        public void configurationChanged() {
            StateStyler.this.refresh();
        }
    };

    public StateStyler(StyleHandler handler) {
        this.generator = Activator.getDefaultStyleGenerator();
        this.handler = handler;
        this.generator.addListener(this.listener);
    }

    protected void refresh() {
        this.handler.setStyle(this.generator.generateStyle(this.currentState));
    }

    public void style(StateInformation state) {
        this.currentState = state;
        this.handler.setStyle(this.generator.generateStyle(state));
    }

    public void dispose() {
        this.generator.removeListener(this.listener);
        this.generator.dispose();
    }
}

