/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.styles.generator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.scada.core.ui.styles.StyleGenerator;
import org.eclipse.scada.core.ui.styles.StyleGeneratorInformation;
import org.eclipse.scada.core.ui.styles.generator.DelegatingStyleGenerator;
import org.eclipse.scada.core.ui.styles.generator.Messages;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceSelectorStyleGenerator
extends DelegatingStyleGenerator {
    private static final Logger logger = LoggerFactory.getLogger(PreferenceSelectorStyleGenerator.class);
    private final IPreferenceStore preferenceStore;
    private StyleGenerator currentGenerator;

    public PreferenceSelectorStyleGenerator(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
        this.preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                logger.trace("Property change - name: {}, newValue: {}", (Object)event.getProperty(), event.getNewValue());
                if ("styleGeneratorId".equals(event.getProperty())) {
                    logger.info("Change of style generator: {}", event.getNewValue());
                    PreferenceSelectorStyleGenerator.this.handleChange(event.getNewValue());
                }
            }
        });
        this.setInitial();
    }

    protected void setInitial() {
        this.setById(this.preferenceStore.getString("styleGeneratorId"));
    }

    protected void setById(String generatorId) {
        if (this.currentGenerator != null) {
            this.currentGenerator.dispose();
            this.currentGenerator = null;
        }
        IConfigurationElement ele = StyleGeneratorInformation.getConfiguration(generatorId);
        this.currentGenerator = this.create(ele);
        this.setStyleGenerator(this.currentGenerator);
    }

    protected void handleChange(Object newValue) {
        if (newValue instanceof String) {
            this.setById((String)newValue);
        } else {
            this.setStyleGenerator(null);
        }
    }

    private StyleGenerator create(IConfigurationElement ele) {
        if (ele == null) {
            return null;
        }
        try {
            Object o = ele.createExecutableExtension(Messages.PreferenceSelectorStyleGenerator_2);
            if (o instanceof StyleGenerator) {
                return (StyleGenerator)o;
            }
            logger.warn("Class referenced in 'generatorClass' did not implement {}", StyleGenerator.class);
            return null;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "org.eclipse.scada.core.ui.styles");
            return null;
        }
    }
}

