/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.discoverer.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.ui.connection.AbstractConnectionDiscoverer;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.discoverer.file.Activator;
import org.eclipse.scada.core.ui.connection.discoverer.file.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceDiscoverer
extends AbstractConnectionDiscoverer {
    private static final Logger logger = LoggerFactory.getLogger(ResourceDiscoverer.class);
    protected static final String STORE_ID_DELIM = "*";

    public ResourceDiscoverer() {
        this.initialize();
    }

    protected abstract void initialize();

    protected void load(File file) {
        logger.info("Loading: {}", (Object)file);
        try {
            this.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.scada.core.ui.connection.discoverer.file", Messages.ResourceDiscoverer_ErrorLoad, (Throwable)e));
        }
    }

    protected void load(InputStream stream) {
        this.load(new InputStreamReader(stream, Charset.forName("UTF-8")));
    }

    protected void load(Reader stream) {
        block12: {
            try {
                try {
                    this.performLoad(stream);
                }
                catch (Throwable e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.scada.core.ui.connection.discoverer.file", Messages.ResourceDiscoverer_ErrorLoad, e));
                    if (stream == null) break block12;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scada.core.ui.connection.discoverer.file", Messages.ResourceDiscoverer_ErrorCloseStream, (Throwable)e2));
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scada.core.ui.connection.discoverer.file", Messages.ResourceDiscoverer_ErrorCloseStream, (Throwable)e));
                    }
                }
            }
        }
    }

    private void performLoad(Reader stream) {
        HashSet<ConnectionDescriptor> result = new HashSet<ConnectionDescriptor>();
        LineNumberReader reader = new LineNumberReader(stream);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                ConnectionDescriptor info = this.convert(line);
                if (info == null) continue;
                result.add(info);
            }
        }
        catch (IOException iOException) {}
        this.setConnections(result);
    }

    private ConnectionDescriptor convert(String line) {
        ConnectionDescriptor cd;
        block5: {
            String[] tok;
            block4: {
                try {
                    tok = line.split(Pattern.quote(STORE_ID_DELIM), 2);
                    if (tok.length != 0) break block4;
                    return null;
                }
                catch (IllegalArgumentException e) {
                    logger.warn(String.format("Failed to parse '%s'", line), (Throwable)e);
                    return null;
                }
            }
            cd = tok.length == 1 ? new ConnectionDescriptor(ConnectionInformation.fromURI((String)tok[0])) : new ConnectionDescriptor(ConnectionInformation.fromURI((String)tok[1]), tok[0], null);
            if (cd.getConnectionInformation() != null) break block5;
            return null;
        }
        return cd;
    }
}

