/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.common;

import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.da.ui.common.Messages;
import org.eclipse.scada.da.ui.common.internal.Activator;

public enum ValueType {
    NULL(10, Messages.getString("ValueType.NULL.label")){

        @Override
        public Variant convertTo(String value) {
            return Variant.NULL;
        }
    }
    ,
    STRING(20, Messages.getString("ValueType.STRING.label")){

        @Override
        public Variant convertTo(String value) {
            value = value.replace(Activator.NATIVE_LS, "\n");
            return Variant.valueOf((Object)value);
        }
    }
    ,
    STRING_CRLF(21, Messages.getString("ValueType.STRING_CRLF.label")){

        @Override
        public Variant convertTo(String value) {
            value = value.replace(Activator.NATIVE_LS, "\r\n");
            return Variant.valueOf((Object)value);
        }
    }
    ,
    INT(30, Messages.getString("ValueType.INT.label")){

        @Override
        public Variant convertTo(String value) throws NotConvertableException {
            Variant stringValue = Variant.valueOf((Object)value);
            try {
                return Variant.valueOf((int)stringValue.asInteger());
            }
            catch (NullValueException nullValueException) {
                return Variant.NULL;
            }
        }
    }
    ,
    LONG(40, Messages.getString("ValueType.LONG.label")){

        @Override
        public Variant convertTo(String value) throws NotConvertableException {
            Variant stringValue = Variant.valueOf((Object)value);
            try {
                return Variant.valueOf((long)stringValue.asLong());
            }
            catch (NullValueException nullValueException) {
                return Variant.NULL;
            }
        }
    }
    ,
    DOUBLE(50, Messages.getString("ValueType.DOUBLE.label")){

        @Override
        public Variant convertTo(String value) throws NotConvertableException {
            Variant stringValue = Variant.valueOf((Object)value);
            try {
                return Variant.valueOf((double)stringValue.asDouble());
            }
            catch (NullValueException nullValueException) {
                return Variant.NULL;
            }
        }
    }
    ,
    BOOLEAN(60, Messages.getString("ValueType.BOOLEAN.label")){

        @Override
        public Variant convertTo(String value) throws NotConvertableException {
            Variant stringValue = Variant.valueOf((Object)value);
            return Variant.valueOf((boolean)stringValue.asBoolean());
        }
    };

    private int index;
    private String label;

    private ValueType(int index, String label) {
        this.index = index;
        this.label = label;
    }

    public String label() {
        return this.label;
    }

    public int index() {
        return this.index;
    }

    public abstract Variant convertTo(String var1) throws NotConvertableException;

    public static ValueType fromVariantType(VariantType type) {
        switch (type) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case INT32: {
                return INT;
            }
            case INT64: {
                return LONG;
            }
            case NULL: {
                return NULL;
            }
            case STRING: {
                return STRING;
            }
        }
        return STRING;
    }

    /* synthetic */ ValueType(String string, int n, int n2, String string2, ValueType valueType) {
        this(n2, string2);
    }
}

