/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.viewer.ext.item;

import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.vi.ui.user.viewer.ViewManager;
import org.eclipse.scada.vi.ui.user.viewer.ext.ViewerExtension;
import org.eclipse.scada.vi.ui.viewer.ext.item.AbstractItemExtension;
import org.eclipse.scada.vi.ui.viewer.ext.item.DataItemLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SystemMessageExtension
extends AbstractItemExtension
implements ViewerExtension {
    public Control create(Composite parent, ViewManager viewManager, boolean horizontal) {
        return new SystemMessageLabel(parent, this.connectionId, this.itemId).getControl();
    }

    public static class SystemMessageLabel
    extends DataItemLabel {
        private final LocalResourceManager resourceManager;

        public SystemMessageLabel(Composite parent, String connectionId, String itemId) {
            super(parent, connectionId, itemId);
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), (Control)this.label);
        }

        @Override
        protected void bind() {
            this.model.addValueChangeListener(new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    if (!SystemMessageLabel.this.label.isDisposed()) {
                        SystemMessageLabel.this.process(event.diff.getNewValue());
                    }
                }
            });
        }

        protected void process(Object value) {
            String text = "";
            if (value instanceof Variant) {
                text = ((Variant)value).asString("");
            }
            int idx = text.indexOf("#");
            String icon = null;
            if (idx >= 0 && idx < text.length()) {
                icon = text.substring(0, idx);
                text = text.substring(idx + 1);
            }
            this.label.setText(text);
            if (icon == null) {
                this.label.setImage(null);
            } else {
                this.label.setImage(this.resourceManager.createImageWithDefault(this.makeDescriptor(icon)));
            }
            this.label.getParent().layout();
        }

        private ImageDescriptor makeDescriptor(String icon) {
            if ("info".equalsIgnoreCase(icon)) {
                return ImageDescriptor.createFromFile(SystemMessageExtension.class, (String)"icons/information.png");
            }
            if ("warning".equalsIgnoreCase(icon)) {
                return ImageDescriptor.createFromFile(SystemMessageExtension.class, (String)"icons/exclamation.png");
            }
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }
}

