/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.UnionSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.core.ui.connection.login.SessionManager;
import org.eclipse.scada.utils.str.StringReplacer;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.details.model.AndTransformer;
import org.eclipse.scada.vi.details.model.BoolLEDComponent;
import org.eclipse.scada.vi.details.model.ButtonComponent;
import org.eclipse.scada.vi.details.model.CheckComponent;
import org.eclipse.scada.vi.details.model.Component;
import org.eclipse.scada.vi.details.model.CompositeTransformer;
import org.eclipse.scada.vi.details.model.FillLayoutComponent;
import org.eclipse.scada.vi.details.model.GroupGridComponent;
import org.eclipse.scada.vi.details.model.GroupGridEntry;
import org.eclipse.scada.vi.details.model.HiddenComponent;
import org.eclipse.scada.vi.details.model.ItemValueSource;
import org.eclipse.scada.vi.details.model.LabelComponent;
import org.eclipse.scada.vi.details.model.LinkComponent;
import org.eclipse.scada.vi.details.model.NotTransformer;
import org.eclipse.scada.vi.details.model.OrTransformer;
import org.eclipse.scada.vi.details.model.ProgressComponent;
import org.eclipse.scada.vi.details.model.Registration;
import org.eclipse.scada.vi.details.model.SimpleGridComponent;
import org.eclipse.scada.vi.details.model.TextComponent;
import org.eclipse.scada.vi.details.model.TextInputComponent;
import org.eclipse.scada.vi.details.model.TextInputMultiComponent;
import org.eclipse.scada.vi.details.model.URLImageComponent;
import org.eclipse.scada.vi.details.model.ValueComponent;
import org.eclipse.scada.vi.details.model.ValueSetComponent;
import org.eclipse.scada.vi.details.model.ValueSource;
import org.eclipse.scada.vi.details.swt.Constants;
import org.eclipse.scada.vi.details.swt.DetailComponent;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.impl.AndTransformerController;
import org.eclipse.scada.vi.details.swt.impl.CompositeSummaryProvider;
import org.eclipse.scada.vi.details.swt.impl.OrTransformerController;
import org.eclipse.scada.vi.details.swt.impl.ViewContext;
import org.eclipse.scada.vi.details.swt.impl.visibility.ComponentVisibility;
import org.eclipse.scada.vi.details.swt.impl.visibility.SubTrackingVisibleComponent;
import org.eclipse.scada.vi.details.swt.impl.visibility.TrackingVisibleComponent;
import org.eclipse.scada.vi.details.swt.impl.visibility.VisibilityProvider;
import org.eclipse.scada.vi.details.swt.impl.visibility.VisibilityProviderFactory;
import org.eclipse.scada.vi.details.swt.source.ItemValueSourceController;
import org.eclipse.scada.vi.details.swt.source.NotEvaluatorController;
import org.eclipse.scada.vi.details.swt.source.ValueSourceController;
import org.eclipse.scada.vi.details.swt.widgets.BoolLEDComposite;
import org.eclipse.scada.vi.details.swt.widgets.BrowserComponent;
import org.eclipse.scada.vi.details.swt.widgets.ButtonComposite;
import org.eclipse.scada.vi.details.swt.widgets.CheckComposite;
import org.eclipse.scada.vi.details.swt.widgets.LabelComposite;
import org.eclipse.scada.vi.details.swt.widgets.LinkComposite;
import org.eclipse.scada.vi.details.swt.widgets.ProgressComposite;
import org.eclipse.scada.vi.details.swt.widgets.TextComposite;
import org.eclipse.scada.vi.details.swt.widgets.TextInputComposite;
import org.eclipse.scada.vi.details.swt.widgets.TextInputMultiComposite;
import org.eclipse.scada.vi.details.swt.widgets.URLImageLabel;
import org.eclipse.scada.vi.details.swt.widgets.ValueComposite;
import org.eclipse.scada.vi.details.swt.widgets.ValueSetComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DetailComponentImpl
implements DetailComponent {
    private final Component component;
    private final List<ComponentVisibility> visibilites = new LinkedList<ComponentVisibility>();
    private VisibilityProviderFactory visibleFactory;
    private final WritableSet descriptors = new WritableSet();
    private final CompositeSummaryProvider summaryProvider = new CompositeSummaryProvider();
    private final ViewContext viewContext;

    public DetailComponentImpl(Component component, ViewContext viewContext) {
        this.viewContext = viewContext;
        this.component = component;
    }

    @Override
    public void dispose() {
        for (ComponentVisibility visibility : this.visibilites) {
            visibility.dispose();
        }
        this.summaryProvider.dispose();
    }

    @Override
    public void start() {
        for (ComponentVisibility visibility : this.visibilites) {
            visibility.start();
        }
    }

    @Override
    public void stop() {
        for (ComponentVisibility visibility : this.visibilites) {
            visibility.stop();
        }
    }

    @Override
    public IObservableSet getDescriptors() {
        LinkedList<Object> lists = new LinkedList<Object>();
        lists.add(this.descriptors);
        for (ComponentVisibility visibility : this.visibilites) {
            lists.add(visibility.getDescriptors());
        }
        return new UnionSet(lists.toArray(new IObservableSet[lists.size()]));
    }

    private void addDescriptor(DataItemDescriptor descriptor) {
        if (descriptor != null) {
            this.descriptors.add((Object)descriptor);
        }
    }

    @Override
    public void init(VisibilityProviderFactory visibleFactory, Composite parent, Map<String, String> properties) {
        this.visibleFactory = visibleFactory;
        if (this.component instanceof LabelComponent) {
            this.createLabel(parent, (LabelComponent)this.component, properties);
        } else if (this.component instanceof FillLayoutComponent) {
            this.createFillLayout(parent, (FillLayoutComponent)this.component, properties);
        } else if (this.component instanceof SimpleGridComponent) {
            this.createSimpleGrid(parent, (SimpleGridComponent)this.component, properties);
        } else if (this.component instanceof GroupGridComponent) {
            this.createGroupGrid(parent, (GroupGridComponent)this.component, properties);
        } else if (this.component instanceof ButtonComponent) {
            this.createButton(parent, (ButtonComponent)this.component, properties);
        } else if (this.component instanceof BoolLEDComponent) {
            this.createBoolLED(parent, (BoolLEDComponent)this.component, properties);
        } else if (this.component instanceof ValueSetComponent) {
            this.createValueSet(parent, (ValueSetComponent)this.component, properties);
        } else if (this.component instanceof ValueComponent) {
            this.createValue(parent, (ValueComponent)this.component, properties);
        } else if (this.component instanceof TextComponent) {
            this.createText(parent, (TextComponent)this.component, properties);
        } else if (this.component instanceof TextInputComponent) {
            this.createTextInput(parent, (TextInputComponent)this.component, properties);
        } else if (this.component instanceof TextInputMultiComponent) {
            this.createTextInputMulti(parent, (TextInputMultiComponent)this.component, properties);
        } else if (this.component instanceof CheckComponent) {
            this.createCheck(parent, (CheckComponent)this.component, properties);
        } else if (this.component instanceof LinkComponent) {
            this.createLink(parent, (LinkComponent)this.component, properties);
        } else if (this.component instanceof ProgressComponent) {
            this.createProgress(parent, (ProgressComponent)this.component, properties);
        } else if (this.component instanceof URLImageComponent) {
            this.createURLImage(parent, (URLImageComponent)this.component, properties);
        } else if (this.component instanceof org.eclipse.scada.vi.details.model.BrowserComponent) {
            this.createBrowser(parent, (org.eclipse.scada.vi.details.model.BrowserComponent)this.component, properties);
        } else if (this.component instanceof HiddenComponent) {
            this.createHidden((HiddenComponent)this.component, properties);
        }
    }

    private void createHidden(HiddenComponent component, Map<String, String> properties) {
        DataItemDescriptor descriptor = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        this.addDescriptor(descriptor);
    }

    private void createURLImage(final Composite parent, final URLImageComponent component, Map<String, String> properties) {
        final DataItemDescriptor descriptor = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                URLImageLabel image = new URLImageLabel(parent, 0, descriptor, component);
                this.setSummaryProvider(image.getSummaryProvider());
                this.trackControl((Control)image);
                this.trackItem(descriptor);
            }
        });
        this.addComponent(visibility);
    }

    private void createBrowser(final Composite parent, final org.eclipse.scada.vi.details.model.BrowserComponent component, Map<String, String> properties) {
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                BrowserComponent image = new BrowserComponent(parent, 0, null, component);
                this.setSummaryProvider(image.getSummaryProvider());
                this.trackControl((Control)image);
            }
        });
        this.addComponent(visibility);
    }

    private void createProgress(final Composite parent, final ProgressComponent component, final Map<String, String> properties) {
        final DataItemDescriptor progressItem = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                ProgressComposite progress = new ProgressComposite(parent, 0, progressItem, DetailComponentImpl.resolve(component.getFormat(), properties), component.getDecimal(), DetailComponentImpl.resolve(component.getAttribute(), properties), component.getMax(), component.getMin(), component.getFactor(), component.getWidth(), DetailComponentImpl.resolve(component.getHdConnectionId(), properties), DetailComponentImpl.resolve(component.getHdItemId(), properties), component.getHdQueryString());
                progress.setNullReplacementValue(component.getNullReplacementValue());
                this.setSummaryProvider(progress.getSummaryProvider());
                this.trackControl((Control)progress);
                this.trackItem(progressItem);
            }
        });
        this.addComponent(visibility);
    }

    private void createLink(final Composite parent, final LinkComponent component, final Map<String, String> properties) {
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                LinkComposite link = new LinkComposite(parent, 0, DetailComponentImpl.resolve(component.getFormat(), properties));
                this.trackControl((Control)link);
            }
        });
        this.addComponent(visibility);
    }

    private void createCheck(final Composite parent, final CheckComponent component, final Map<String, String> properties) {
        final DataItemDescriptor descriptor = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        final DataItemDescriptor readDescriptor = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getReadDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                CheckComposite check = new CheckComposite(DetailComponentImpl.this.viewContext, parent, 0, descriptor, DetailComponentImpl.resolve(component.getFormat(), properties), DetailComponentImpl.resolve(component.getAttribute(), properties), readDescriptor);
                this.setSummaryProvider(check.getSummaryProvider());
                this.trackControl((Control)check);
                this.trackItem(descriptor);
                this.trackItem(readDescriptor);
            }
        });
        this.addComponent(visibility);
    }

    private void createText(final Composite parent, final TextComponent component, final Map<String, String> properties) {
        final DataItemDescriptor textItem = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                TextComposite text = new TextComposite(parent, 0, textItem, DetailComponentImpl.resolve(component.getFormat(), properties), component.getDecimal(), component.isIsText(), DetailComponentImpl.resolve(component.getAttribute(), properties), component.getWidth(), component.getHeight(), component.isDate(), component.getTextHeight(), component.getTextMap(), DetailComponentImpl.resolve(component.getHdConnectionId(), properties), DetailComponentImpl.resolve(component.getHdItemId(), properties), component.getHdQueryString());
                text.setNullReplacementValue(component.getNullReplacementValue());
                this.setSummaryProvider(text.getSummaryProvider());
                this.trackControl((Control)text);
                this.trackItem(textItem);
            }
        });
        this.addComponent(visibility);
    }

    private void createTextInput(final Composite parent, final TextInputComponent component, final Map<String, String> properties) {
        final DataItemDescriptor textInputItem = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        final DataItemDescriptor readItem = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getReadDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                TextInputComposite valueSet = new TextInputComposite(DetailComponentImpl.this.viewContext, parent, 0, textInputItem, DetailComponentImpl.resolve(component.getFormat(), properties), component.getCeil(), component.getFloor(), component.getDecimal(), component.isIsText(), DetailComponentImpl.resolve(component.getAttribute(), properties), readItem, component.getHdConnectionId(), DetailComponentImpl.resolve(component.getHdItemId(), properties), component.getWidth(), component.getHdQueryString());
                valueSet.setNullReplacementValue(component.getNullReplacementValue());
                this.setSummaryProvider(valueSet.getSummaryProvider());
                this.trackControl((Control)valueSet);
                this.trackItem(textInputItem);
                this.trackItem(readItem);
            }
        });
        this.addComponent(visibility);
    }

    private void createTextInputMulti(final Composite parent, final TextInputMultiComponent component, final Map<String, String> properties) {
        final DataItemDescriptor textInputItem = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                TextInputMultiComposite text = new TextInputMultiComposite(DetailComponentImpl.this.viewContext, parent, 0, textInputItem, DetailComponentImpl.resolve(component.getFormat(), properties), DetailComponentImpl.resolve(component.getAttribute(), properties), component.getHdConnectionId(), DetailComponentImpl.resolve(component.getHdItemId(), properties));
                text.setNullReplacementValue(component.getNullReplacementValue());
                this.setSummaryProvider(text.getSummaryProvider());
                this.trackControl((Control)text);
                this.trackItem(textInputItem);
            }
        });
        this.addComponent(visibility);
    }

    private void createValue(final Composite parent, final ValueComponent component, final Map<String, String> properties) {
        final DataItemDescriptor item = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                ValueComposite value = new ValueComposite(parent, 0, item, DetailComponentImpl.resolve(component.getFormat(), properties), component.getDecimal(), component.isIsText(), DetailComponentImpl.resolve(component.getAttribute(), properties), component.getDate(), DetailComponentImpl.resolve(component.getHdConnectionId(), properties), DetailComponentImpl.resolve(component.getHdItemId(), properties), component.getHdQueryString());
                value.setNullReplacementValue(component.getNullReplacementValue());
                this.setSummaryProvider(value.getSummaryProvider());
                this.trackControl((Control)value);
                this.trackItem(item);
            }
        });
        this.addComponent(visibility);
    }

    private void createValueSet(final Composite parent, final ValueSetComponent component, final Map<String, String> properties) {
        final DataItemDescriptor valueItem = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getValueDescriptor(), properties));
        final DataItemDescriptor setItem = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getSetDescriptor(), properties));
        final DataItemDescriptor resetItem = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getResetDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                ValueSetComposite valueSet = new ValueSetComposite(DetailComponentImpl.this.viewContext, parent, 0, valueItem, setItem, resetItem, DetailComponentImpl.resolve(component.getFormat(), properties), component.getCeil(), component.getFloor(), component.getDecimal(), component.isIsText(), DetailComponentImpl.resolve(component.getAttribute(), properties), DetailComponentImpl.resolve(component.getHdConnectionId(), properties), DetailComponentImpl.resolve(component.getHdItemId(), properties));
                valueSet.setNullReplacementValue(component.getNullReplacementValue());
                this.setSummaryProvider(valueSet.getSummaryProvider());
                this.trackControl((Control)valueSet);
                this.trackItem(valueItem);
                this.trackItem(setItem);
                this.trackItem(resetItem);
            }
        });
        this.addComponent(visibility);
    }

    private void createGroupGrid(final Composite parent, final GroupGridComponent component, final Map<String, String> properties) {
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                Composite childParent = new Composite(parent, 0);
                childParent.setLayout((Layout)new GridLayout(component.getCols(), component.isEqually()));
                for (GroupGridEntry groupEntry : component.getGroups()) {
                    if (groupEntry.getPermission() == null) {
                        DetailComponentImpl.this.createGroupGridEntry(properties, childParent, groupEntry);
                        continue;
                    }
                    if (!SessionManager.getDefault().hasRole(groupEntry.getPermission())) continue;
                    DetailComponentImpl.this.createGroupGridEntry(properties, childParent, groupEntry);
                }
                this.trackControl((Control)childParent);
            }
        });
        this.addComponent(visibility);
    }

    private void createGroupGridEntry(final Map<String, String> properties, final Composite childParent, final GroupGridEntry groupEntry) {
        VisibilityProvider provider = this.visibleFactory.createProvider(groupEntry.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new SubTrackingVisibleComponent(){

            @Override
            public void create() {
                Group groupWidget = new Group(childParent, 0);
                groupWidget.setLayout((Layout)new GridLayout(1, false));
                groupWidget.setLayoutData((Object)new GridData(4, 4, true, false));
                String label = groupEntry.getLabel();
                if (label != null) {
                    groupWidget.setText(label);
                }
                for (Component child : groupEntry.getComponents()) {
                    DetailComponentImpl comp = new DetailComponentImpl(child, DetailComponentImpl.this.viewContext);
                    Composite wrapper = new Composite((Composite)groupWidget, 0);
                    wrapper.setLayoutData((Object)new GridData(4, 4, true, false));
                    wrapper.setLayout((Layout)new FillLayout());
                    comp.init(DetailComponentImpl.this.visibleFactory, wrapper, properties);
                    this.trackSub(comp);
                }
                this.trackControl((Control)groupWidget);
            }
        });
        this.addComponent(visibility);
    }

    private void createSimpleGrid(final Composite parent, final SimpleGridComponent component, final Map<String, String> properties) {
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new SubTrackingVisibleComponent(){

            @Override
            public void create() {
                Composite childParent = new Composite(parent, 0);
                childParent.setLayout((Layout)new GridLayout(component.getCols(), component.isEqually()));
                for (Component child : component.getChildren()) {
                    DetailComponentImpl comp = new DetailComponentImpl(child, DetailComponentImpl.this.viewContext);
                    this.trackSub(comp);
                    Composite wrapper = new Composite(childParent, 0);
                    wrapper.setLayout((Layout)new FillLayout());
                    wrapper.setLayoutData((Object)new GridData(4, 4, true, false));
                    comp.init(DetailComponentImpl.this.visibleFactory, wrapper, properties);
                }
                this.trackControl((Control)childParent);
            }
        });
        this.addComponent(visibility);
    }

    private void createBoolLED(final Composite parent, final BoolLEDComponent component, final Map<String, String> properties) {
        final DataItemDescriptor item = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                BoolLEDComposite led = new BoolLEDComposite(parent, 0, item, DetailComponentImpl.resolve(component.getFormat(), properties), component.isExpectedValue(), component.isAlarm(), component.isOnOff(), DetailComponentImpl.resolve(component.getAttribute(), properties));
                this.setSummaryProvider(led.getSummaryProvider());
                this.trackControl((Control)led);
                this.trackItem(item);
            }
        });
        this.addComponent(visibility);
    }

    private void createButton(final Composite parent, final ButtonComponent component, final Map<String, String> properties) {
        String readDescriptor = component.getReadDescriptor();
        final DataItemDescriptor readItem = readDescriptor != null && !readDescriptor.equals("") ? DataItemDescriptor.create(DetailComponentImpl.resolve(component.getReadDescriptor(), properties)) : null;
        final DataItemDescriptor writeItem = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getWriteDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                ButtonComposite button = new ButtonComposite(DetailComponentImpl.this.viewContext, parent, 0, readItem, writeItem, DetailComponentImpl.resolve(component.getFormat(), properties), DetailComponentImpl.resolve(component.getValue(), properties), DetailComponentImpl.createValueSource(component.getActive(), properties), (Collection<Registration>)component.getRegistrations(), properties, DetailComponentImpl.resolve(component.getAttribute(), properties), component.getTextHeight());
                this.setSummaryProvider(button.getSummaryProvider());
                this.trackControl((Control)button);
                this.trackItem(writeItem);
                this.trackItem(readItem);
            }
        });
        this.addComponent(visibility);
    }

    private static ValueSourceController createValueSource(ValueSource valueSource, Map<String, String> properties) {
        if (valueSource instanceof NotTransformer) {
            return new NotEvaluatorController(DetailComponentImpl.createValueSource(((NotTransformer)valueSource).getValue(), properties));
        }
        if (valueSource instanceof AndTransformer) {
            return new AndTransformerController(DetailComponentImpl.createValueSources((List<ValueSource>)((CompositeTransformer)valueSource).getValues(), properties));
        }
        if (valueSource instanceof OrTransformer) {
            return new OrTransformerController(DetailComponentImpl.createValueSources((List<ValueSource>)((CompositeTransformer)valueSource).getValues(), properties));
        }
        if (valueSource instanceof ItemValueSource) {
            ItemValueSource itemSource = (ItemValueSource)valueSource;
            return new ItemValueSourceController(DetailComponentImpl.resolve(itemSource.getValueKey(), properties));
        }
        return null;
    }

    private static List<ValueSourceController> createValueSources(List<ValueSource> values, Map<String, String> properties) {
        LinkedList<ValueSourceController> result = new LinkedList<ValueSourceController>();
        for (ValueSource source : values) {
            result.add(DetailComponentImpl.createValueSource(source, properties));
        }
        return result;
    }

    private void createFillLayout(final Composite parent, final FillLayoutComponent component, final Map<String, String> properties) {
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new SubTrackingVisibleComponent(){

            @Override
            public void create() {
                Composite childParent = new Composite(parent, 0);
                childParent.setLayout((Layout)new FillLayout(512));
                for (Component child : component.getChildren()) {
                    DetailComponentImpl comp = new DetailComponentImpl(child, DetailComponentImpl.this.viewContext);
                    comp.init(DetailComponentImpl.this.visibleFactory, childParent, properties);
                    this.trackSub(comp);
                }
                this.trackControl((Control)childParent);
            }
        });
        this.addComponent(visibility);
    }

    private void createLabel(final Composite parent, final LabelComponent component, final Map<String, String> properties) {
        final DataItemDescriptor item = DataItemDescriptor.create(DetailComponentImpl.resolve(component.getDescriptor(), properties));
        VisibilityProvider provider = this.visibleFactory.createProvider(component.getVisibility());
        ComponentVisibility visibility = new ComponentVisibility(provider, new TrackingVisibleComponent(){

            @Override
            public void create() {
                LabelComposite label = new LabelComposite(parent, 0, item, DetailComponentImpl.resolve(component.getFormat(), properties));
                this.setSummaryProvider(label.getSummaryProvider());
                this.trackControl((Control)label);
                this.trackItem(item);
            }
        });
        this.addComponent(visibility);
    }

    public static String resolve(String input, Map<String, String> properties) {
        if (input == null) {
            return null;
        }
        return StringReplacer.replace((String)input, (StringReplacer.ReplaceSource)StringReplacer.newSource(properties), (Pattern)Constants.DEFAULT_PATTERN);
    }

    private void addComponent(ComponentVisibility visibility) {
        this.visibilites.add(visibility);
        this.summaryProvider.addSummaryProvider(visibility.getSummaryProvider());
    }

    @Override
    public SummaryProvider getSummaryProvider() {
        return this.summaryProvider;
    }
}

