/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl.tab;

import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.data.SummaryListener;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.data.SummaryStateInformation;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.scada.vi.details.swt.impl.tab.TabProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;

public abstract class BaseFolderImplementation
implements SummaryListener,
TabProvider.Folder {
    private SummaryProvider summaryProvider;
    protected SummaryInformation summaryInformation = new SummaryInformation(Collections.emptyMap());
    protected StateStyler styler;
    protected final int index;
    private final String label;
    private StyleBlinker blinker;
    private Boolean visible;
    private final MenuManager mgr;
    private final Action dumpAction;
    private final ActionContributionItem contribution;

    public BaseFolderImplementation(int index, String label, MenuManager mgr) {
        this.index = index;
        this.label = label;
        this.mgr = mgr;
        this.dumpAction = new Action("Dump summaries for: " + this.label){

            public void run() {
                BaseFolderImplementation.this.summaryInformation.dump(System.out);
            }
        };
        this.contribution = new ActionContributionItem((IAction)this.dumpAction);
    }

    protected void addMenu() {
        if (!Boolean.getBoolean("vi.debug")) {
            return;
        }
        this.mgr.add((IContributionItem)this.contribution);
        this.mgr.update();
    }

    protected void removeMenu() {
        this.mgr.remove((IContributionItem)this.contribution);
        this.mgr.update();
    }

    @Override
    public void setSummaryProvider(SummaryProvider summaryProvider) {
        this.summaryProvider = summaryProvider;
        summaryProvider.addSummaryListener((SummaryListener)this);
    }

    public void summaryChanged(SummaryInformation summaryInformation) {
        this.summaryInformation = summaryInformation;
        if (this.styler != null) {
            this.styler.style((StateInformation)new SummaryStateInformation(summaryInformation));
        }
    }

    @Override
    public void dispose() {
        this.summaryProvider.removeSummaryListener((SummaryListener)this);
    }

    protected void useItem(final Item item) {
        if (this.label != null) {
            item.setText(this.label);
        }
        item.setImage(this.getEmptyImage());
        this.blinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle currentStyle) {
                if (!item.isDisposed()) {
                    BaseFolderImplementation.this.updateItem(item, currentStyle);
                }
            }
        };
        this.styler = new StateStyler((StyleHandler)this.blinker);
        this.styler.style((StateInformation)new SummaryStateInformation(this.summaryInformation));
    }

    protected void updateItem(Item item, StyleBlinker.CurrentStyle currentStyle) {
        if (currentStyle.image != null) {
            item.setImage(currentStyle.image);
        } else {
            item.setImage(this.getEmptyImage());
        }
    }

    private Image getEmptyImage() {
        return Activator.getDefault().getImageRegistry().get("empty");
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible != null && this.visible == visible) {
            return;
        }
        if (visible) {
            this.show();
        } else {
            this.hide();
        }
    }

    protected void hide() {
        this.visible = false;
        this.styler.dispose();
        this.blinker.dispose();
        this.removeMenu();
    }

    protected void show() {
        this.visible = true;
        this.addMenu();
    }
}

