/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl.tab;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.scada.vi.data.SummaryListener;
import org.eclipse.scada.vi.details.swt.impl.tab.BaseFolderImplementation;
import org.eclipse.scada.vi.details.swt.impl.tab.TabProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class EclipseTabProvider
implements TabProvider {
    private final CTabFolder folder;
    private final MenuManager mgr;

    public EclipseTabProvider(Composite parent) {
        this.folder = new CTabFolder(parent, 0x800880);
        this.folder.setTabHeight(24);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mgr = new MenuManager();
        Menu menu = this.mgr.createContextMenu((Control)this.folder);
        this.folder.setMenu(menu);
    }

    @Override
    public TabProvider.Folder createFolder(int index, String label) {
        Composite wrapper = new Composite((Composite)this.folder, 0);
        wrapper.setLayout((Layout)new FillLayout());
        return new FolderImplementation(this.folder, wrapper, index, label, this.mgr);
    }

    @Override
    public void dispose() {
        this.folder.dispose();
    }

    private static final class FolderImplementation
    extends BaseFolderImplementation
    implements TabProvider.Folder,
    SummaryListener {
        private final Composite container;
        private CTabItem item;
        private final CTabFolder folder;

        private FolderImplementation(CTabFolder folder, Composite container, int index, String label, MenuManager mgr) {
            super(index, label, mgr);
            this.folder = folder;
            this.container = container;
        }

        @Override
        public Composite getContainer() {
            return this.container;
        }

        @Override
        protected void show() {
            super.show();
            int tabIndex = this.findIndex(this.index);
            if (tabIndex < 0) {
                this.item = new CTabItem(this.folder, 0);
                this.item.setData("order", (Object)this.index);
            } else {
                this.item = new CTabItem(this.folder, 0, tabIndex);
                this.item.setData("order", (Object)this.index);
            }
            this.item.setControl((Control)this.container);
            this.useItem((Item)this.item);
        }

        @Override
        protected void hide() {
            super.hide();
            this.item.dispose();
        }

        @Override
        public void dispose() {
            this.hide();
            super.dispose();
        }

        private int findIndex(int index) {
            CTabItem[] items = this.folder.getItems();
            int i = 0;
            while (i < items.length) {
                CTabItem item = items[i];
                int order = (Integer)item.getData("order");
                if (order > index) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

