/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl.visibility;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.UnionSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.details.swt.DetailComponent;
import org.eclipse.scada.vi.details.swt.impl.CompositeSummaryProvider;
import org.eclipse.scada.vi.details.swt.impl.visibility.TrackingVisibleComponent;

public abstract class SubTrackingVisibleComponent
extends TrackingVisibleComponent {
    private final Set<DetailComponent> subs = new HashSet<DetailComponent>();
    private final WritableSet descriptors = new WritableSet();
    private IObservableSet unionSet = Observables.emptyObservableSet();
    private final ISetChangeListener setListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            event.diff.applyTo((Set)SubTrackingVisibleComponent.this.descriptors);
        }
    };
    private final CompositeSummaryProvider compositeSummaryProvider = new CompositeSummaryProvider();

    @Override
    public SummaryProvider getSummaryProvider() {
        return this.compositeSummaryProvider;
    }

    @Override
    public void start() {
        super.start();
        for (DetailComponent component : this.subs) {
            component.start();
        }
    }

    @Override
    public void stop() {
        for (DetailComponent component : this.subs) {
            component.stop();
        }
        super.stop();
    }

    protected void trackSub(DetailComponent subComponent) {
        this.subs.add(subComponent);
        this.compositeSummaryProvider.addSummaryProvider(subComponent.getSummaryProvider());
        this.update();
    }

    protected void untrackSub(DetailComponent subComponent) {
        this.compositeSummaryProvider.removeSummaryProvider(subComponent.getSummaryProvider());
        this.subs.remove(subComponent);
        this.update();
    }

    private void update() {
        this.unionSet.removeSetChangeListener(this.setListener);
        this.unionSet.dispose();
        this.descriptors.clear();
        LinkedList<IObservableSet> childSets = new LinkedList<IObservableSet>();
        for (DetailComponent component : this.subs) {
            childSets.add(component.getDescriptors());
        }
        this.unionSet = childSets.isEmpty() ? Observables.emptyObservableSet() : new UnionSet(childSets.toArray(new IObservableSet[childSets.size()]));
        this.unionSet.addSetChangeListener(this.setListener);
        this.descriptors.addAll((Collection)this.unionSet);
    }

    @Override
    public void dispose() {
        for (DetailComponent sub : this.subs) {
            sub.dispose();
        }
        this.compositeSummaryProvider.dispose();
        super.dispose();
    }

    @Override
    public IObservableSet getDescriptors() {
        return new UnionSet(new IObservableSet[]{super.getDescriptors(), this.descriptors});
    }
}

