/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DataItemToolTip
extends ToolTip {
    private final Item item;
    private Label headerLabel;
    private StyledText text;
    private StyledString currentText;
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public DataItemToolTip(Control control, int style, boolean manualActivation, Item item) {
        super(control, style, manualActivation);
        this.item = item;
    }

    public DataItemToolTip(Control control, Item item) {
        super(control);
        this.item = item;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite wrapper = new Composite(parent, 0);
        wrapper.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DataItemToolTip.this.resourceManager.dispose();
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 20;
        wrapper.setLayout((Layout)layout);
        wrapper.setBackground(wrapper.getDisplay().getSystemColor(1));
        wrapper.setBackgroundMode(1);
        this.headerLabel = new Label(wrapper, 0);
        this.headerLabel.setText(this.item.getId());
        this.headerLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.headerLabel.setFont(JFaceResources.getHeaderFont());
        Label warnIcon = new Label(wrapper, 0);
        warnIcon.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        warnIcon.setImage(Activator.getDefault().getImageRegistry().get("warn.big"));
        this.text = new StyledText(wrapper, 2);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.currentText != null) {
            this.text.setText(this.currentText.getString());
            this.text.setStyleRanges(this.currentText.getStyleRanges());
        }
        return wrapper;
    }

    public void setText(StyledString text) {
        this.currentText = new StyledString();
        this.currentText.append(text);
    }
}

