/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.Map;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.widgets.GenericComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelComposite
extends GenericComposite {
    private static final Logger logger = LoggerFactory.getLogger(LabelComposite.class);
    private final Label label;
    private final String format;

    public LabelComposite(Composite parent, int style, DataItemDescriptor descriptor, String format) {
        super(parent, style, null, null);
        this.setLayout((Layout)new FillLayout());
        this.label = new Label((Composite)this, 0);
        this.format = format;
        if (descriptor != null) {
            this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
        } else {
            this.label.setText(format);
        }
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation state) {
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        DataItemValue value = values.get("value").getValue();
        if (value == null) {
            return;
        }
        this.label.setText(String.format(this.format, value.getValue().toLabel()));
        if (state.isError()) {
            this.label.setBackground(Display.getCurrent().getSystemColor(3));
        } else {
            this.label.setBackground(null);
        }
    }
}

