/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.scada.vi.data.RegistrationManager;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.data.SummaryListener;
import org.eclipse.scada.vi.data.SummaryProvider;

public class RegistrationManagerSummaryProvider
implements SummaryProvider,
RegistrationManager.Listener {
    private final RegistrationManager registrationManager;
    private SummaryInformation summaryInformation;
    private final Set<SummaryListener> listeners = new CopyOnWriteArraySet<SummaryListener>();
    private boolean closed;

    public RegistrationManagerSummaryProvider(RegistrationManager registrationManager) {
        this.registrationManager = registrationManager;
        registrationManager.addListener((RegistrationManager.Listener)this);
        this.triggerDataUpdate();
    }

    public void dispose() {
        this.registrationManager.removeListener((RegistrationManager.Listener)this);
    }

    public SummaryInformation getSummary() {
        return this.summaryInformation;
    }

    public void addSummaryListener(SummaryListener summaryListener) {
        if (this.listeners.add(summaryListener)) {
            summaryListener.summaryChanged(this.summaryInformation);
        }
    }

    public void removeSummaryListener(SummaryListener summaryListener) {
        this.listeners.remove(summaryListener);
    }

    public void triggerDataUpdate() {
        this.summaryInformation = new SummaryInformation(this.registrationManager.getData());
        SummaryInformation si = this.closed ? new SummaryInformation(Collections.emptyMap()) : this.summaryInformation;
        for (SummaryListener listener : this.listeners) {
            listener.summaryChanged(si);
        }
    }

    public void open() {
        this.closed = false;
        this.triggerDataUpdate();
    }

    public void close() {
        this.closed = true;
        this.triggerDataUpdate();
    }
}

