/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.widgets.DescriptorLabel;
import org.eclipse.scada.vi.details.swt.widgets.Helper;
import org.eclipse.scada.vi.details.swt.widgets.ReadableComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueComposite
extends ReadableComposite {
    private static final Logger logger = LoggerFactory.getLogger(ValueComposite.class);
    private final Label dataLabel;
    private final Boolean isDate;
    private final ControlImage controlImage;

    public ValueComposite(Composite parent, int style, DataItemDescriptor descriptor, String format, String decimal, boolean isText, String attribute, Boolean isDate, String hdConnectionId, String hdItemId, String queryString) {
        super(parent, style, format, decimal, isText, attribute);
        this.isDate = isDate;
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.center = true;
        layout.spacing = 7;
        layout.pack = true;
        this.setLayout((Layout)layout);
        this.controlImage = new ControlImage(this, this.registrationManager);
        Helper.createTrendButton(this.controlImage, hdConnectionId, hdItemId, queryString);
        this.dataLabel = new Label((Composite)this, 0);
        RowData rowData = new RowData(80, -1);
        this.dataLabel.setAlignment(131072);
        this.dataLabel.setLayoutData((Object)rowData);
        this.dataLabel.setText("");
        new DescriptorLabel(this, 0, format, descriptor);
        if (descriptor != null) {
            this.controlImage.setDetailItem(descriptor.asItem());
            this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
        }
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation state) {
        Variant value;
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        if (this.getAttribute() == null) {
            try {
                value = values.get("value").getValue().getValue();
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                value = Variant.NULL;
            }
        } else {
            try {
                value = (Variant)values.get("value").getValue().getAttributes().get(this.getAttribute());
            }
            catch (NullPointerException e) {
                logger.info("could not get attribute", (Throwable)e);
                value = Variant.NULL;
            }
        }
        if (value.isDouble()) {
            this.dataLabel.setText(this.getTextDecimal(values, this.getAttribute()));
        } else if (value.isString()) {
            this.dataLabel.setText(this.getText(values, this.getAttribute()));
        } else if (value.isLong()) {
            if (this.isDate == null) {
                this.dataLabel.setText(this.getText(values, this.getAttribute()));
            } else if (this.isDate.booleanValue()) {
                this.dataLabel.setText(this.getDateAsString(values, this.getAttribute()));
            } else {
                this.dataLabel.setText(this.getText(values, this.getAttribute()));
            }
        } else if (value.isNull()) {
            this.dataLabel.setText(this.getNullReplacementValue() == null ? "" : this.getNullReplacementValue());
        } else {
            this.dataLabel.setText(this.getText(values, this.getAttribute()));
        }
    }
}

