/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.printing;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;

public class PrintProcessor {
    private final List<ValueInformation> valueInformation;
    private final Map<String, List<Double>> values;

    public PrintProcessor(List<ValueInformation> vis, Map<String, List<Double>> values) {
        this.valueInformation = vis;
        this.values = values;
    }

    public void print(Printer printer) {
        double maxX = Double.NEGATIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        for (List<Double> vs : this.values.values()) {
            for (Double d : vs) {
                if (d > maxX) {
                    maxX = d;
                }
                if (!(d < minX)) continue;
                minX = d;
            }
        }
        minX = 0.0;
        maxX *= 1.5;
        Calendar startTimestamp = null;
        Calendar endTimestamp = null;
        for (ValueInformation vi : this.valueInformation) {
            if (startTimestamp == null || startTimestamp.after(vi.getStartTimestamp())) {
                startTimestamp = Calendar.getInstance();
                startTimestamp.setTimeInMillis(vi.getStartTimestamp());
            }
            if (endTimestamp != null && !endTimestamp.before(vi.getEndTimestamp())) continue;
            endTimestamp = Calendar.getInstance();
            endTimestamp.setTimeInMillis(vi.getEndTimestamp());
        }
        GC gc = null;
        try {
            printer.startJob("Chart");
            printer.startPage();
            gc = new GC((Drawable)printer);
            this.drawChart((Device)printer, gc, minX, maxX, startTimestamp, endTimestamp);
            gc.dispose();
            gc = null;
            printer.endPage();
            printer.endJob();
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    private void drawChart(Device device, GC gc, double minX, double maxX, Calendar startTimestamp, Calendar endTimestamp) {
        Rectangle bounds = device.getBounds();
        Color color = new Color(device, new RGB(0, 0, 0));
        Rectangle drawBounds = new Rectangle(bounds.x + 10, bounds.y + 10, bounds.width - 20, bounds.height - 20);
        gc.setForeground(color);
        gc.drawRectangle(drawBounds);
        for (Map.Entry<String, List<Double>> row : this.values.entrySet()) {
            this.drawRow(device, gc, row.getKey(), row.getValue(), drawBounds, minX, maxX);
        }
    }

    private void drawRow(Device device, GC gc, String label, List<Double> data, Rectangle bounds, double minX, double maxX) {
        Rectangle deviceBounds = device.getBounds();
        gc.setLineWidth(1);
        int size = data.size();
        double diff = maxX - minX;
        Point lastPoint = null;
        int i = 0;
        while (i < size) {
            ValueInformation info = this.valueInformation.get(i);
            if (info.getQuality() > 0.75) {
                double posX = (double)bounds.width / (double)size * (double)i;
                double posY = data.get(i) / diff * (double)bounds.height;
                Point point = new Point((int)posX + bounds.x, (int)posY + bounds.y);
                if (lastPoint != null) {
                    gc.drawLine(lastPoint.x, deviceBounds.height - lastPoint.y, point.x, deviceBounds.height - lastPoint.y);
                    gc.drawLine(point.x, deviceBounds.height - lastPoint.y, point.x, deviceBounds.height - point.y);
                }
                lastPoint = point;
            } else {
                lastPoint = null;
            }
            ++i;
        }
    }
}

