/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.part.flags;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.dataitem.details.part.AbstractBaseDetailsPart;
import org.eclipse.scada.da.client.dataitem.details.part.flags.AttributeEntry;
import org.eclipse.scada.da.client.dataitem.details.part.flags.GroupEntry;
import org.eclipse.scada.da.client.dataitem.details.part.flags.Messages;
import org.eclipse.scada.ui.databinding.ListeningStyledCellLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FlagsDetailsPart
extends AbstractBaseDetailsPart {
    private TreeViewer viewer;
    private TreeViewerColumn col1;
    private TreeViewerColumn col2;
    private final WritableSet groupSet = new WritableSet();

    @Override
    public void createPart(Composite parent) {
        super.createPart(parent);
        this.viewer = new TreeViewer(parent);
        IObservableFactory factory = new IObservableFactory(){

            public IObservable createObservable(Object target) {
                if (target instanceof IObservable) {
                    return (IObservable)target;
                }
                if (target instanceof GroupEntry) {
                    return ((GroupEntry)((Object)target)).getEntries();
                }
                return null;
            }
        };
        ObservableSetTreeContentProvider contentProvider = new ObservableSetTreeContentProvider(factory, null);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        TableLayout tableLayout = new TableLayout();
        this.col1 = new TreeViewerColumn(this.viewer, 0);
        this.col1.getColumn().setText(Messages.FlagsDetailsPart_ColFlagLabel);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.col1.setLabelProvider((CellLabelProvider)new ColumnLabelLabelProvider(contentProvider.getRealizedElements()));
        this.col2 = new TreeViewerColumn(this.viewer, 0);
        this.col2.getColumn().setText(Messages.FlagsDetailsPart_ColStateLabel);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.col2.setLabelProvider((CellLabelProvider)new ColumnLabelStateProvider(contentProvider.getRealizedElements()));
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLayout((Layout)tableLayout);
        this.viewer.setUseHashlookup(true);
        this.viewer.setInput((Object)this.groupSet);
        this.groupSet.add((Object)new GroupEntry("error", Messages.FlagsDetailsPart_GroupErrorLabel));
        this.groupSet.add((Object)new GroupEntry("alarm", Messages.FlagsDetailsPart_GroupAlarmLabel));
        this.groupSet.add((Object)new GroupEntry("warning", Messages.FlagsDetailsPart_GroupWarningLabel));
        this.groupSet.add((Object)new GroupEntry("blocked", Messages.FlagsDetailsPart_GroupBlockingLabel));
        this.groupSet.add((Object)new GroupEntry("ackRequired", Messages.FlagsDetailsPart_GroupAknLabel));
        this.groupSet.add((Object)new GroupEntry("manual", Messages.FlagsDetailsPart_ManualLabel));
    }

    @Override
    protected void update() {
        HashMap<String, Map<String, Variant>> state = new HashMap<String, Map<String, Variant>>();
        DataItemValue value = this.getValue();
        if (value == null) {
            value = DataItemValue.DISCONNECTED;
        }
        for (Map.Entry entry : value.getAttributes().entrySet()) {
            for (Object o : this.groupSet) {
                GroupEntry groupEntry = (GroupEntry)((Object)o);
                if (((String)entry.getKey()).equals(groupEntry.getAttribute())) {
                    this.addAttr(state, groupEntry.getAttribute(), (String)entry.getKey(), (Variant)entry.getValue());
                    continue;
                }
                if (!((String)entry.getKey()).endsWith("." + groupEntry.getAttribute())) continue;
                this.addAttr(state, groupEntry.getAttribute(), (String)entry.getKey(), (Variant)entry.getValue());
            }
        }
        for (Object o : this.groupSet) {
            GroupEntry groupEntry = (GroupEntry)((Object)o);
            Map attrState = (Map)state.get(groupEntry.getAttribute());
            groupEntry.setState(attrState);
        }
    }

    private void addAttr(Map<String, Map<String, Variant>> state, String attribute, String key, Variant value) {
        Map<String, Variant> entry = state.get(attribute);
        if (entry == null) {
            entry = new HashMap<String, Variant>();
            state.put(attribute, entry);
        }
        entry.put(key, value);
    }

    public static abstract class AbstractLabelProvider
    extends ListeningStyledCellLabelProvider
    implements PropertyChangeListener {
        protected final StyledString.Styler activeStyler = StyledString.createColorRegistryStyler((String)"org.eclipse.scada.da.client.dataitem.details.activeAttribute", null);
        protected final StyledString.Styler inactiveStyler = StyledString.createColorRegistryStyler((String)"org.eclipse.scada.da.client.dataitem.details.inactiveAttribute", null);

        public AbstractLabelProvider(IObservableSet itemsThatNeedLabels) {
            super(itemsThatNeedLabels);
        }

        protected void removeListenerFrom(Object next) {
            if (next instanceof GroupEntry) {
                ((GroupEntry)((Object)next)).removePropertyChangeListener(this);
            }
        }

        protected void addListenerTo(Object next) {
            if (next instanceof GroupEntry) {
                ((GroupEntry)((Object)next)).addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, evt.getSource()));
        }
    }

    public static class ColumnLabelLabelProvider
    extends AbstractLabelProvider {
        public ColumnLabelLabelProvider(IObservableSet itemsThatNeedLabels) {
            super(itemsThatNeedLabels);
        }

        public void update(ViewerCell cell) {
            Object ele = cell.getElement();
            if (ele instanceof GroupEntry) {
                StyledString str = new StyledString();
                str.append(((GroupEntry)((Object)ele)).getLabel());
                str.append(" ");
                str.append("[" + ((GroupEntry)((Object)ele)).getAttribute() + "]", StyledString.DECORATIONS_STYLER);
                str.append(" ");
                str.append("(");
                str.append("" + ((GroupEntry)((Object)ele)).getActiveCount(), StyledString.COUNTER_STYLER);
                str.append(")");
                cell.setText(str.getString());
                cell.setStyleRanges(str.getStyleRanges());
            } else if (ele instanceof AttributeEntry) {
                StyledString str = new StyledString();
                str.append(((AttributeEntry)ele).getName(), ((AttributeEntry)ele).isActive() ? this.activeStyler : this.inactiveStyler);
                cell.setText(str.getString());
                cell.setStyleRanges(str.getStyleRanges());
            }
        }
    }

    public static class ColumnLabelStateProvider
    extends AbstractLabelProvider {
        public ColumnLabelStateProvider(IObservableSet itemsThatNeedLabels) {
            super(itemsThatNeedLabels);
        }

        public void update(ViewerCell cell) {
            Object ele = cell.getElement();
            if (ele instanceof GroupEntry) {
                cell.setText(String.format(Messages.FlagsDetailsPart_GroupSumFormat, ((GroupEntry)((Object)ele)).getActiveCount(), ((GroupEntry)((Object)ele)).getCount()));
            } else if (ele instanceof AttributeEntry) {
                StyledString str = new StyledString();
                if (((AttributeEntry)ele).isActive()) {
                    str.append(Messages.FlagsDetailsPart_ActiveMarker, this.activeStyler);
                } else {
                    str.append(Messages.FlagsDetailsPart_InactiveMarker, this.inactiveStyler);
                }
                cell.setText(str.getString());
                cell.setStyleRanges(str.getStyleRanges());
            }
        }
    }
}

