/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.connection.data;

import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.ui.connection.data.AbstractItemHolder;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.osgi.framework.BundleContext;

public class ItemListenerHolder
extends AbstractItemHolder {
    private final ItemUpdateListener listener;
    private ConnectionService connection;

    public ItemListenerHolder(BundleContext context, Item item, ItemUpdateListener listener) {
        super(context, item, null);
        this.listener = listener;
        this.init();
    }

    public ItemListenerHolder(BundleContext context, Item item, ItemUpdateListener listener, HolderListener holderListener) {
        super(context, item, holderListener);
        this.listener = listener;
        this.init();
    }

    @Override
    protected void bindConnection(ConnectionService connectionService) {
        super.bindConnection(connectionService);
        if (connectionService != null) {
            connectionService.getItemManager().addItemUpdateListener(this.item.getId(), this.listener);
            this.connection = connectionService;
        }
    }

    @Override
    protected void unbindConnection() {
        if (this.connection != null) {
            this.connection.getItemManager().removeItemUpdateListener(this.item.getId(), this.listener);
            this.connection = null;
        }
        super.unbindConnection();
    }

    public static interface HolderListener {
        public void connectionChange(ConnectionService var1);

        public void connectionStateChange(Connection var1, ConnectionState var2, Throwable var3);
    }
}

