/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.export.excel;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.ae.ui.views.export.excel.FileTarget;
import org.eclipse.scada.ae.ui.views.export.excel.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileSelectionPage
extends WizardPage {
    private Text text;
    private final FileTarget target;

    protected FileSelectionPage(FileTarget target) {
        super("fileSelection");
        this.setTitle(Messages.FileSelectionPage_Title);
        this.setDescription(Messages.FileSelectionPage_Description);
        this.target = target;
    }

    public void createControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(wrapper, 0);
        label.setText(Messages.FileSelectionPage_Label_OutputFile);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.text = new Text(wrapper, 2052);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button button = new Button(wrapper, 8);
        button.setText(Messages.FileSelectionPage_Button_Browse);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionPage.this.updateFile();
            }
        });
        this.setControl((Control)wrapper);
        this.update();
    }

    protected void updateFile() {
        FileDialog dlg = new FileDialog(this.getShell(), 73728);
        dlg.setFilterExtensions(new String[]{Messages.FileSelectionPage_FilterExtension});
        dlg.setFilterNames(new String[]{Messages.FileSelectionPage_FilterName});
        dlg.setOverwrite(true);
        dlg.setText(Messages.FileSelectionPage_FileDialog_Text);
        String fileName = dlg.open();
        if (fileName == null) {
            this.setFile(null);
            this.update();
        } else {
            this.setFile(new File(fileName));
            this.update();
        }
    }

    private void setFile(File file) {
        if (file != null) {
            this.text.setText(file.getAbsolutePath());
        } else {
            this.text.setText("");
        }
    }

    private void update() {
        String fileName = this.text.getText();
        File file = null;
        if (fileName.length() != 0) {
            file = new File(fileName);
        }
        this.target.setFile(file);
        this.setPageComplete(file != null);
        if (file == null) {
            this.setMessage(Messages.FileSelectionPage_Message_NoFileSelected, 3);
        } else {
            this.setMessage(Messages.FileSelectionPage_Message_Ok, 1);
        }
    }
}

