/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.chart.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.vi.chart.model.ChartView;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.ui.chart.draw2d.ChartFigure;
import org.eclipse.scada.vi.ui.chart.draw2d.ChartHelper;
import org.eclipse.scada.vi.ui.draw2d.ErrorFigure;
import org.eclipse.scada.vi.ui.draw2d.FactoryContext;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.scada.vi.ui.draw2d.loader.SymbolLoader;
import org.eclipse.scada.vi.ui.draw2d.primitives.FigureController;
import org.eclipse.swt.widgets.Display;

public class ChartController
extends FigureController {
    private final ChartFigure figure;
    private final Figure wrapperFigure;
    private final ErrorFigure errorFigure;
    private final SymbolLoader symbolLoader;
    private final FactoryContext context;

    public ChartController(SymbolController symbolController, ResourceManager resourceManager, ChartView view, SymbolLoader symbolLoader, FactoryContext context) {
        super(symbolController, resourceManager);
        this.context = context;
        this.symbolLoader = symbolLoader;
        this.wrapperFigure = new Figure(){

            public void addNotify() {
                super.addNotify();
                ChartController.this.start();
            }

            public void removeNotify() {
                ChartController.this.stop();
                super.removeNotify();
            }
        };
        this.wrapperFigure.setOpaque(false);
        this.figure = new ChartFigure(Display.getCurrent(), resourceManager);
        this.wrapperFigure.setLayoutManager((LayoutManager)new StackLayout());
        this.wrapperFigure.add((IFigure)this.figure);
        this.errorFigure = new ErrorFigure();
        symbolController.addElement((Primitive)view, (Object)this);
        this.applyCommon(view);
    }

    protected void applyCommon(ChartView view) {
        this.setChartConfigurationUri(view.getConfigurationUri());
        super.applyCommon((org.eclipse.scada.vi.model.Figure)view);
    }

    public void setChartConfigurationUri(String configurationUri) {
        if (this.wrapperFigure.getChildren().contains(this.errorFigure)) {
            this.wrapperFigure.remove((IFigure)this.errorFigure);
        }
        if (this.figure != null && configurationUri != null) {
            try {
                String uri = this.symbolLoader.resolveUri(configurationUri);
                this.figure.setConfiguration(ChartHelper.loadConfiguraton(uri));
                this.context.loadedResource(URI.createURI((String)uri));
            }
            catch (Exception e) {
                this.wrapperFigure.add((IFigure)this.errorFigure);
                this.errorFigure.setException((Throwable)e);
            }
        }
    }

    public IFigure getPropertyFigure() {
        return this.figure;
    }

    public IFigure getFigure() {
        return this.wrapperFigure;
    }

    public void setOpaque(Boolean flag) {
        this.setOpaque(flag, false);
    }
}

