/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.vi.ui.user.navigation.ToolBarNavigatorItem;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstance;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceDescriptor;
import org.eclipse.scada.vi.ui.user.viewer.ViewManager;
import org.eclipse.scada.vi.ui.user.viewer.ViewManagerListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolBarNavigator
implements ViewManagerListener {
    private static final Logger logger = LoggerFactory.getLogger(ToolBarNavigator.class);
    private final ToolBar toolbar;
    private final ViewManager viewManager;
    private final Map<ViewInstanceDescriptor, ToolBarNavigatorItem> itemMap = new HashMap<ViewInstanceDescriptor, ToolBarNavigatorItem>();
    private final LocalResourceManager resourceManager;
    private final Set<ViewInstanceDescriptor> visibleDescriptors = new HashSet<ViewInstanceDescriptor>();

    public ToolBarNavigator(Composite parent, int style, ViewManager viewManager) {
        this.viewManager = viewManager;
        this.toolbar = new ToolBar(parent, style);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()));
        this.toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ToolBarNavigator.this.handleDispose();
            }
        });
        viewManager.addViewManagerListener(this);
    }

    public void dispose() {
        this.toolbar.dispose();
    }

    protected void handleDispose() {
        this.resourceManager.dispose();
    }

    public void setLayoutData(Object layoutData) {
        this.toolbar.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.toolbar;
    }

    protected boolean hasButton(ViewInstanceDescriptor descriptor) {
        return descriptor.getParentId() == null || descriptor.getParentId().isEmpty();
    }

    @Override
    public void viewVisibilityChanged(ViewInstance viewInstance, boolean visible) {
        logger.debug("Visibility changed: {} - {}", (Object)viewInstance.getDescriptor(), (Object)visible);
        if (this.toolbar.isDisposed()) {
            return;
        }
        ViewInstanceDescriptor descriptor = viewInstance.getDescriptor();
        if (!this.isMain(descriptor)) {
            return;
        }
        if (visible) {
            this.visibleDescriptors.add(descriptor);
            ToolBarNavigatorItem item = this.itemMap.get(descriptor);
            if (item == null) {
                int index = this.calculateToolbarIndex(descriptor);
                logger.info("Adding view at index {}", (Object)index);
                item = new ToolBarNavigatorItem(this, this.toolbar, index, this.viewManager, viewInstance, (ResourceManager)this.resourceManager);
                this.itemMap.put(descriptor, item);
                this.toolbar.getParent().getParent().layout();
            }
        } else {
            this.visibleDescriptors.remove(descriptor);
            ToolBarNavigatorItem item = this.itemMap.remove(descriptor);
            if (item != null) {
                item.dispose();
            }
            this.toolbar.getParent().getParent().layout();
        }
    }

    @Override
    public void viewLazynessChanged(ViewInstance viewInstance, boolean state) {
        logger.debug("Lazyness changed: {} - {}", (Object)viewInstance.getDescriptor(), (Object)state);
        ToolBarNavigatorItem item = this.itemMap.get(viewInstance.getDescriptor());
        if (item != null) {
            item.setLazy(state);
        }
    }

    @Override
    public void viewDefaultChanged(ViewInstance viewInstance, boolean state) {
        logger.debug("Default changed: {} - {}", (Object)viewInstance.getDescriptor(), (Object)state);
    }

    @Override
    public void viewActiveChanged(ViewInstance viewInstance, boolean state) {
        logger.debug("Active changed: {} - {}", (Object)viewInstance.getDescriptor(), (Object)state);
        ToolBarNavigatorItem item = this.itemMap.get(viewInstance.getDescriptor());
        if (item != null) {
            item.setActive(state);
        }
    }

    @Override
    public void viewControlChanged(ViewInstance viewInstance) {
    }

    public int calculateToolbarIndex(ViewInstanceDescriptor descriptor) {
        if (!this.isMain(descriptor)) {
            logger.debug("Has parent: {}", (Object)descriptor);
            return -1;
        }
        ArrayList<ViewInstanceDescriptor> data = new ArrayList<ViewInstanceDescriptor>(this.visibleDescriptors);
        Iterator i = data.iterator();
        while (i.hasNext()) {
            if (this.isMain((ViewInstanceDescriptor)i.next())) continue;
            logger.debug("{} has parent, remove: ", (Object)descriptor);
            i.remove();
        }
        data.add(descriptor);
        Collections.sort(data, ViewInstanceDescriptor.DESCRIPTOR_ORDER_COMPARATOR);
        logger.debug("Sort order: {}", data);
        int result = data.indexOf(descriptor);
        logger.debug("Index is: {}", (Object)result);
        return result;
    }

    protected boolean isMain(ViewInstanceDescriptor descriptor) {
        return descriptor.isMainView();
    }
}

