/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.viewer;

import java.net.URI;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceFactory;

public class ViewInstanceDescriptor {
    public static final Comparator<? super ViewInstanceDescriptor> DESCRIPTOR_ORDER_COMPARATOR = new Comparator<ViewInstanceDescriptor>(){

        @Override
        public int compare(ViewInstanceDescriptor o1, ViewInstanceDescriptor o2) {
            return Integer.valueOf(o1.getOrder()).compareTo(o2.getOrder());
        }
    };
    private final String id;
    private final String parentId;
    private final URI uri;
    private final String name;
    private final Map<String, String> properties;
    private final Boolean zooming;
    private final Expression visibleExpression;
    private final Expression lazyExpression;
    private final int order;
    private final boolean defaultInstance;
    private final Expression defaultInstanceExpression;
    private final ViewInstanceFactory factory;
    private final String summaryConnectionId;
    private final String summaryItemId;
    private final boolean mainView;

    public ViewInstanceDescriptor(String id, String parentId, ViewInstanceFactory factory, URI uri, String name, int order, boolean defaultInstance, Boolean zooming, Expression lazyExpression, Expression visibleExpression, Expression defaultInstanceExpression, String summaryConnectionId, String summaryItemId, boolean mainView, Map<String, String> properties) {
        this.id = id;
        this.parentId = parentId;
        this.factory = factory;
        this.uri = uri;
        this.name = name;
        this.properties = properties;
        this.order = order;
        this.defaultInstance = defaultInstance;
        this.zooming = zooming;
        this.lazyExpression = lazyExpression;
        this.visibleExpression = visibleExpression;
        this.defaultInstanceExpression = defaultInstanceExpression;
        this.summaryConnectionId = summaryConnectionId;
        this.summaryItemId = summaryItemId;
        this.mainView = mainView;
    }

    public boolean isMainView() {
        return this.mainView;
    }

    public boolean isDefaultInstance() {
        return this.defaultInstance;
    }

    public Expression getDefaultInstanceExpression() {
        return this.defaultInstanceExpression;
    }

    public Expression getLazyExpression() {
        return this.lazyExpression;
    }

    public Expression getVisibleExpression() {
        return this.visibleExpression;
    }

    public Boolean getZooming() {
        return this.zooming;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public int getOrder() {
        return this.order;
    }

    public ViewInstanceFactory getFactory() {
        return this.factory;
    }

    public String getSummaryConnectionId() {
        return this.summaryConnectionId;
    }

    public String getSummaryItemId() {
        return this.summaryItemId;
    }

    public String toString() {
        return String.format("[ViewInstance: %s]", this.id);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewInstanceDescriptor other = (ViewInstanceDescriptor)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

