/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.discoverer.osgi;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.AbstractConnectionDiscoverer;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.discoverer.osgi.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoverer
extends AbstractConnectionDiscoverer
implements ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDiscoverer.class);
    private final BundleContext context;
    private final Set<ServiceReference<?>> references = new HashSet();

    public ServiceDiscoverer() {
        this.context = Activator.getDefault().getBundle().getBundleContext();
        this.setup();
    }

    private synchronized void setup() {
        try {
            this.context.addServiceListener((ServiceListener)this, String.format("(%s=%s)", "objectClass", ConnectionService.class.getName()));
            ServiceReference[] refs = this.context.getAllServiceReferences(ConnectionService.class.getName(), null);
            if (refs != null) {
                ServiceReference[] serviceReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    this.addReference(ref);
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            logger.warn("Invalid syntax when setting up filter", (Throwable)e);
            return;
        }
    }

    private ConnectionInformation fromReference(ServiceReference<?> ref) {
        Object o = ref.getProperty("connection.uri");
        if (o instanceof String) {
            String uri = (String)o;
            return ConnectionInformation.fromURI((String)uri);
        }
        return null;
    }

    private void addReference(ServiceReference<?> ref) {
        logger.info("Adding service: {}", ref);
        if (this.references.add(ref)) {
            this.update();
        }
    }

    private void removeReference(ServiceReference<?> ref) {
        logger.info("Removing service: {}", ref);
        if (this.references.remove(ref)) {
            this.update();
        }
    }

    private void update() {
        HashSet<ConnectionDescriptor> infos = new HashSet<ConnectionDescriptor>();
        for (ServiceReference<?> ref : this.references) {
            ConnectionInformation ci = this.fromReference(ref);
            if (ci == null) continue;
            Object o = ref.getProperty("service.pid");
            String id = o != null ? o.toString() : null;
            Object description = ref.getProperty("service.description");
            ConnectionDescriptor cd = new ConnectionDescriptor(ci, id, description == null ? null : description.toString());
            infos.add(cd);
        }
        this.setConnections(infos);
    }

    public synchronized void dispose() {
        super.dispose();
        this.context.removeServiceListener((ServiceListener)this);
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.addReference(event.getServiceReference());
                break;
            }
            case 2: {
                this.update();
                break;
            }
            case 4: {
                this.removeReference(event.getServiceReference());
            }
        }
    }
}

