/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.test.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.commands.operations.OperationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.ui.client.test.Activator;
import org.eclipse.scada.da.ui.client.test.wizards.Messages;
import org.eclipse.scada.da.ui.client.test.wizards.WriteAttributesOperationWizardValuePage;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class WriteAttributesOperationWizard
extends Wizard
implements INewWizard {
    private WriteAttributesOperationWizardValuePage page;
    private IStructuredSelection selection;

    public boolean performFinish() {
        final Item item = this.page.getItem();
        final Map<String, Variant> attributes = this.page.getAttributes();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        WriteAttributesOperationWizard.this.doFinish(monitor, item, attributes);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("WriteAttributesOperationWizard.WriteError_Title"), (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IProgressMonitor monitor, Item item, Map<String, Variant> attributes) throws Exception {
        monitor.beginTask(Messages.getString("WriteAttributesOperationWizard.TaskName"), 2);
        monitor.worked(1);
        try {
            DataItemHolder itemHolder = new DataItemHolder(Activator.getDefault().getBundle().getBundleContext(), item, null);
            if (!itemHolder.waitForConnection(5000L)) {
                this.handleError(new RuntimeException(Messages.getString("WriteAttributesOperationWizard.ErrNoConnection")).fillInStackTrace());
                return;
            }
            NotifyFuture future = itemHolder.writeAtrtibutes(attributes, null, (CallbackHandler)new DisplayCallbackHandler(this.getShell(), "Write Attributes", "Confirmation required to write attributes"));
            try {
                WriteAttributeResults results = (WriteAttributeResults)future.get();
                if (!results.isSuccess()) {
                    this.handleError(attributes, results);
                }
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void handleError(final Throwable e) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)WriteAttributesOperationWizard.this.getShell(), (String)Messages.getString("WriteAttributesOperationWizard.WriteError_Title"), (String)e.getMessage(), (IStatus)new Status(4, "org.eclipse.scada.da.ui.client.test", e.getMessage(), e));
            }
        });
    }

    public void handleError(Map<String, Variant> attributes, WriteAttributeResults results) {
        MultiStatus status = new MultiStatus("org.eclipse.scada.da.ui.client.test", 0, Messages.getString("WriteAttributesOperationWizard.Status_Message"), null);
        if (attributes.size() != results.size()) {
            status.add((IStatus)new OperationStatus(2, "org.eclipse.scada.da.ui.client.test", 0, String.format(Messages.getString("WriteAttributesOperationWizard.SummaryText"), results.size(), attributes.size()), null));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (!((WriteAttributeResult)entry.getValue()).isError()) continue;
            status.add((IStatus)new OperationStatus(4, "org.eclipse.scada.da.ui.client.test", 0, String.format(Messages.getString("WriteAttributesOperationWizard.EntryMessage"), entry.getKey(), ((WriteAttributeResult)entry.getValue()).getError().getMessage()), null));
        }
        for (String name : attributes.keySet()) {
            if (results.containsKey((Object)name)) continue;
            status.add((IStatus)new OperationStatus(2, "org.eclipse.scada.da.ui.client.test", 0, String.format(Messages.getString("WriteAttributesOperationWizard.Message_MissingAttribute"), name), null));
        }
        final ErrorDialog dialog = new ErrorDialog(this.getShell(), Messages.getString("WriteAttributesOperationWizard.WriteError_Title"), Messages.getString("WriteAttributesOperationWizard.ErrorDialog_Description"), (IStatus)status, 6);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("WriteAttributesOperationWizard.Title"));
        this.selection = selection;
    }

    public void addPages() {
        super.addPages();
        this.page = new WriteAttributesOperationWizardValuePage();
        this.addPage(this.page);
        this.page.setSelection(this.selection);
    }
}

