/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login.factory.internal;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.login.LoginHandler;
import org.eclipse.scada.core.ui.connection.login.StateListener;
import org.eclipse.scada.core.ui.connection.login.factory.internal.LoginConnection;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ConnectionLoginHandler
implements LoginHandler {
    private ConnectionService connectionService;
    private StateListener loginStateListener;
    private volatile boolean complete;
    private volatile boolean ok;
    private Collection<ServiceRegistration<?>> registrations;
    private final LoginConnection loginConnection;
    private final ConnectionStateListener connectionStateListener;
    private BundleContext registerContext;
    private final boolean sessionPrivileges = true;
    private final CallbackHandler callbackHandler;

    public ConnectionLoginHandler(ConnectionService connectionService, LoginConnection loginConnection, CallbackHandler callbackHandler) {
        this.loginConnection = loginConnection;
        this.connectionService = connectionService;
        this.callbackHandler = callbackHandler;
        this.connectionStateListener = new ConnectionStateListener(){

            public void stateChange(Connection connectionInstance, ConnectionState state, Throwable error) {
                ConnectionLoginHandler.this.notifyStateChange(ConnectionLoginHandler.this.connectionService, state, error, true);
            }
        };
    }

    @Override
    public void setStateListener(StateListener loginStateListener) {
        this.loginStateListener = loginStateListener;
    }

    @Override
    public void startLogin() {
        this.notifyStateChange(this.connectionService, ConnectionState.CLOSED, null, false);
        this.connectionService.getConnection().addConnectionStateListener(this.connectionStateListener);
        this.connectionService.setConnectCallbackHandler(this.callbackHandler);
        this.connectionService.connect();
    }

    private void notifyStateChange(ConnectionService service, ConnectionState state, Throwable error, boolean canBeFinal) {
        switch (state) {
            case BOUND: {
                this.markCompleteOk();
                break;
            }
            case CLOSED: {
                if (this.loginConnection.getMode() == LoginConnection.Mode.NORMAL) {
                    this.markCompleteFailure(canBeFinal);
                    break;
                }
                this.markCompleteOk();
                break;
            }
        }
        StateListener loginStateListener = this.loginStateListener;
        if (loginStateListener != null) {
            loginStateListener.stateChanged(this.loginConnection.getConnectionInformation().toMaskedString(), state.toString(), error);
        }
    }

    private void markCompleteFailure(boolean canBeFinal) {
        this.ok = false;
        if (canBeFinal) {
            this.complete = true;
            this.dispose();
        }
    }

    private void markCompleteOk() {
        this.complete = true;
        this.ok = true;
        this.connectionService.getConnection().removeConnectionStateListener(this.connectionStateListener);
        this.checkRegister();
    }

    private void checkRegister() {
        if (this.complete && this.ok) {
            this.register(this.registerContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(BundleContext context) {
        ConnectionLoginHandler connectionLoginHandler = this;
        synchronized (connectionLoginHandler) {
            if (context == null) {
                return;
            }
            if (this.registrations != null) {
                return;
            }
            this.registerContext = context;
            if (!this.complete || !this.ok) {
                return;
            }
            this.registrations = new LinkedList();
        }
        Class[] clazzes = this.connectionService.getSupportedInterfaces();
        String[] str = new String[clazzes.length];
        int i = 0;
        while (i < clazzes.length) {
            str[i] = clazzes[i].getName();
            ++i;
        }
        for (String servicePid : this.loginConnection.getServicePids()) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("connection.uri", this.connectionService.getConnection().getConnectionInformation().toString());
            ((Dictionary)properties).put("service.pid", servicePid);
            if (this.loginConnection.getPriority() != null) {
                ((Dictionary)properties).put("service.ranking", this.loginConnection.getPriority());
            }
            this.registrations.add(context.registerService(str, (Object)this.connectionService, properties));
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.registrations != null) {
            for (ServiceRegistration<?> reg : this.registrations) {
                reg.unregister();
            }
            this.registrations = null;
        }
        if (this.connectionService != null) {
            if (this.connectionStateListener != null) {
                this.connectionService.getConnection().removeConnectionStateListener(this.connectionStateListener);
            }
            this.connectionService.dispose();
            this.connectionService = null;
        }
    }

    @Override
    public boolean isComplete() {
        return this.loginConnection.getMode() != LoginConnection.Mode.NORMAL || this.complete;
    }

    @Override
    public boolean isOk() {
        return this.loginConnection.getMode() != LoginConnection.Mode.NORMAL || this.ok;
    }

    @Override
    public boolean hasRole(String role) {
        try {
            return this.connectionService.getConnection().getPrivileges().contains(role);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }
}

