/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.views;

import java.util.List;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.client.EventListener;
import org.eclipse.scada.ae.data.BrowserType;
import org.eclipse.scada.ae.ui.connection.data.BrowserEntryBean;
import org.eclipse.scada.ae.ui.testing.views.AbstractEntryViewPart;
import org.eclipse.scada.core.data.SubscriptionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventQueryViewPart
extends AbstractEntryViewPart {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEventQueryViewPart.class);
    private EventListenerImpl listener;

    @Override
    protected boolean isSupported(BrowserEntryBean query) {
        return query.getEntry().getTypes().contains(BrowserType.EVENTS);
    }

    @Override
    protected void setEntry(BrowserEntryBean query) {
        logger.info("Setting entry: {}", (Object)query);
        this.entry = query;
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        this.listener = new EventListenerImpl();
        this.entry.getConnection().getConnection().setEventListener(this.entry.getEntry().getId(), (EventListener)this.listener);
    }

    protected abstract void handleDataChanged(List<Event> var1);

    protected abstract void handleStatusChanged(SubscriptionState var1);

    @Override
    protected void clear() {
        if (this.entry != null) {
            if (this.listener != null) {
                this.listener.dispose();
                this.listener = null;
            }
            this.entry.getConnection().getConnection().setEventListener(this.entry.getEntry().getId(), null);
            this.entry = null;
        }
    }

    protected final class EventListenerImpl
    implements EventListener {
        private boolean disposed = false;

        protected EventListenerImpl() {
        }

        public synchronized void dispose() {
            this.disposed = true;
        }

        public synchronized void statusChanged(SubscriptionState state) {
            if (!this.disposed) {
                AbstractEventQueryViewPart.this.handleStatusChanged(state);
            }
        }

        public synchronized void dataChanged(List<Event> addedEvents) {
            if (!this.disposed) {
                AbstractEventQueryViewPart.this.handleDataChanged(addedEvents);
            }
        }
    }
}

