/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scada.ae.ui.testing.navigator.QueryBean;
import org.eclipse.scada.ae.ui.testing.views.AbstractQueryViewPart;
import org.eclipse.scada.ae.ui.testing.views.EventViewHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class QueryOfflineViewPart
extends AbstractQueryViewPart
implements PropertyChangeListener {
    public static final String VIEW_ID = "org.eclipse.scada.ae.ui.testing.QueryOfflineView";
    private TableViewer viewer;
    private IObservableSet events;
    private Label stateLabel;

    @Override
    protected boolean isSupported(QueryBean query) {
        return true;
    }

    @Override
    protected void clear() {
        if (this.events != null) {
            this.events.dispose();
            this.events = null;
        }
        this.viewer.setInput(null);
        if (this.query != null) {
            this.query.removePropertyChangeListener(this);
            this.query = null;
        }
    }

    @Override
    protected void setQuery(QueryBean query) {
        this.query = query;
        this.events = this.query.getEventObservable();
        this.viewer.setInput((Object)this.events);
        query.addPropertyChangeListener(this);
        this.update();
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.stateLabel = new Label(parent, 0);
        this.stateLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = EventViewHelper.createTableViewer(wrapper, this.getViewSite(), this.events);
        this.addSelectionListener();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueryOfflineViewPart.this.update();
            }
        });
    }

    protected void update() {
        if (this.stateLabel.isDisposed()) {
            return;
        }
        if (this.query != null) {
            this.stateLabel.setText(String.format("%s - %s", this.query.getState(), this.query.getCount()));
        } else {
            this.stateLabel.setText("");
        }
    }
}

