/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.scada.ae.data.BrowserType;
import org.eclipse.scada.ae.ui.connection.data.BrowserEntryBean;
import org.eclipse.scada.ae.ui.views.Activator;
import org.eclipse.scada.ae.ui.views.CustomizableAction;
import org.eclipse.scada.ae.ui.views.views.Messages;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionRequest;
import org.eclipse.scada.core.connection.provider.ConnectionRequestTracker;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAlarmsEventsView
extends ViewPart {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAlarmsEventsView.class);
    private static final String CONNECTION_ID = "connection.id";
    private static final String CONNECTION_URI = "connection.uri";
    private static final int RECONNECT_DELAY = 10000;
    private String connectionId = null;
    private String connectionUri = null;
    private org.eclipse.scada.ae.connection.provider.ConnectionService connectionService;
    private ConnectionTracker connectionTracker;
    private ISelectionListener selectionListener;
    private Composite contentPane;
    private Label stateLabel;
    private final Object jobLock = new Object();
    final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChange(Connection changedConnection, ConnectionState state, Throwable error) {
            try {
                if (changedConnection == null) {
                    throw new IllegalArgumentException(Messages.AbstractAlarmsEventsView_IllegalArgument_changedConnection);
                }
                if (!(changedConnection instanceof org.eclipse.scada.ae.client.Connection)) {
                    throw new IllegalArgumentException(String.valueOf(Messages.AbstractAlarmsEventsView_IllegalArgument_changedConnection_Type) + org.eclipse.scada.ae.client.Connection.class.getName());
                }
                if (state == ConnectionState.BOUND) {
                    AbstractAlarmsEventsView.this.onConnect();
                } else {
                    AbstractAlarmsEventsView.this.onDisconnect();
                }
            }
            catch (Exception e) {
                logger.warn("reInitializeConnection ()", (Throwable)e);
            }
        }
    };
    final ConnectionTracker.Listener connectionServiceListener = new ConnectionTracker.Listener(){

        public void setConnection(ConnectionService connectionService) {
            if (connectionService == null) {
                AbstractAlarmsEventsView.this.onDisconnect();
                AbstractAlarmsEventsView.this.connectionService = null;
                return;
            }
            AbstractAlarmsEventsView.this.connectionService = (org.eclipse.scada.ae.connection.provider.ConnectionService)connectionService;
            if (connectionService.getConnection() == null) {
                AbstractAlarmsEventsView.this.onDisconnect();
                return;
            }
            connectionService.getConnection().addConnectionStateListener(AbstractAlarmsEventsView.this.connectionStateListener);
            if (connectionService.getConnection().getState() == ConnectionState.BOUND) {
                AbstractAlarmsEventsView.this.onConnect();
            } else {
                AbstractAlarmsEventsView.this.onDisconnect();
            }
        }
    };
    private Collection<Runnable> taskList = null;

    public void saveState(IMemento memento) {
        memento.putString(CONNECTION_ID, this.connectionId);
        memento.putString(CONNECTION_URI, this.connectionUri);
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            this.connectionId = memento.getString(CONNECTION_ID);
            this.connectionUri = memento.getString(CONNECTION_URI);
        }
        super.init(site, memento);
        try {
            this.reInitializeConnection(this.connectionId, this.connectionUri);
        }
        catch (Exception e) {
            logger.warn("init () - couldn't recreate connection", (Throwable)e);
            this.connectionId = null;
            this.connectionUri = null;
            this.connectionService = null;
            this.connectionTracker = null;
        }
    }

    public void createPartControl(Composite parent) {
        this.addSelectionListener();
        this.contentPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.contentPane.setLayout((Layout)layout);
        this.stateLabel = new Label(this.contentPane, 0);
        this.stateLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void setConnectionId(String connectionId) throws Exception {
        this.reInitializeConnection(connectionId, null);
    }

    public void setConnectionUri(String connectionUri) throws Exception {
        this.reInitializeConnection(null, connectionUri);
    }

    protected void onConnect() {
        this.updateStatusBar();
    }

    protected void onDisconnect() {
        this.updateStatusBar();
    }

    protected boolean isConnected() {
        return this.connectionService != null && this.connectionService.getConnection() != null && this.connectionService.getConnection().getState() == ConnectionState.BOUND;
    }

    private void reInitializeConnection(String connectionId, String connectionUri) throws Exception {
        if (this.connectionTracker == null) {
            if (connectionId != null) {
                this.trackIdConnection(connectionId);
            } else if (connectionUri != null) {
                this.trackUriConnection(connectionUri);
            }
        } else if (this.connectionTracker instanceof ConnectionIdTracker) {
            if (!((ConnectionIdTracker)this.connectionTracker).getConnectionId().equals(connectionId)) {
                this.connectionTracker.close();
                this.connectionTracker = null;
                this.trackIdConnection(connectionId);
            }
        } else if (this.connectionTracker instanceof ConnectionRequestTracker && !((ConnectionRequestTracker)this.connectionTracker).getConnectionInformation().toString().equals(connectionUri)) {
            this.connectionTracker.close();
            this.connectionTracker = null;
            this.trackUriConnection(connectionUri);
        }
    }

    private void trackIdConnection(String connectionId) {
        if (connectionId == null) {
            return;
        }
        this.connectionTracker = new ConnectionIdTracker(Activator.getDefault().getBundle().getBundleContext(), connectionId, this.connectionServiceListener);
        this.connectionId = connectionId;
        this.connectionUri = null;
        this.connectionService = null;
        this.connectionTracker.open();
    }

    private void trackUriConnection(String connectionUri) {
        if (connectionUri == null) {
            return;
        }
        ConnectionInformation ci = ConnectionInformation.fromURI((String)connectionUri);
        ConnectionRequest request = new ConnectionRequest(null, ci, Integer.valueOf(10000), true);
        this.connectionTracker = new ConnectionRequestTracker(Activator.getDefault().getBundle().getBundleContext(), request, this.connectionServiceListener);
        this.connectionId = null;
        this.connectionUri = connectionUri;
        this.connectionService = null;
        this.connectionTracker.open();
    }

    protected void addSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    AbstractAlarmsEventsView.this.setSelection(selection);
                }
            };
            this.getViewSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        }
    }

    protected void setSelection(ISelection selection) {
        if (!(selection instanceof TreeSelection) || selection.isEmpty()) {
            return;
        }
        TreeSelection treeSelection = (TreeSelection)selection;
        if (treeSelection.getFirstElement() instanceof ConnectionHolder) {
            ConnectionHolder connectionHolder = (ConnectionHolder)treeSelection.getFirstElement();
            if (connectionHolder.getConnectionService().getConnection() != null && connectionHolder.getConnectionService().getConnection() instanceof org.eclipse.scada.ae.client.Connection) {
                try {
                    this.setConnectionUri(connectionHolder.getConnectionService().getConnection().getConnectionInformation().toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (treeSelection.getFirstElement() instanceof BrowserEntryBean) {
            BrowserEntryBean browserEntryBean = (BrowserEntryBean)treeSelection.getFirstElement();
            if (browserEntryBean.getConnection() != null && browserEntryBean.getConnection().getConnection() != null) {
                try {
                    this.setConnectionUri(browserEntryBean.getConnection().getConnection().getConnectionInformation().toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (browserEntryBean.getEntry().getTypes().contains(BrowserType.EVENTS)) {
                this.watchPool(browserEntryBean.getEntry().getId());
            }
            if (browserEntryBean.getEntry().getTypes().contains(BrowserType.MONITORS)) {
                this.watchMonitors(browserEntryBean.getEntry().getId());
            }
        }
    }

    protected abstract void watchPool(String var1);

    protected abstract void watchMonitors(String var1);

    protected abstract void updateStatusBar();

    protected void removeSelectionListener() {
        if (this.selectionListener != null) {
            this.getViewSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    public String getConnectionUri() {
        return this.connectionUri;
    }

    public org.eclipse.scada.ae.client.Connection getConnection() {
        if (this.connectionService != null) {
            return this.connectionService.getConnection();
        }
        return null;
    }

    public org.eclipse.scada.ae.connection.provider.ConnectionService getConnectionService() {
        return this.connectionService;
    }

    public Composite getContentPane() {
        return this.contentPane;
    }

    public Label getStateLabel() {
        return this.stateLabel;
    }

    public void dispose() {
        this.removeSelectionListener();
    }

    protected CustomizableAction createCommentAction(Runnable runnable) {
        CustomizableAction action = new CustomizableAction();
        action.setText(Messages.AbstractAlarmsEventsView_SetCommentAction_Text);
        action.setToolTipText(Messages.AbstractAlarmsEventsView_SetCommentAction_ToolTip);
        action.setDescription(Messages.AbstractAlarmsEventsView_SetCommentAction_Description);
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/event_comment.gif")));
        action.setRunnable(runnable);
        return action;
    }

    protected abstract Realm getRealm();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleJob(Runnable runnable) {
        Object object = this.jobLock;
        synchronized (object) {
            boolean created = false;
            if (this.taskList == null) {
                created = true;
                this.taskList = new LinkedList<Runnable>();
            }
            this.taskList.add(runnable);
            if (created && this.getRealm() != null) {
                this.getRealm().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractAlarmsEventsView.this.getRealm().timerExec(1000, new Runnable(){

                            @Override
                            public void run() {
                                AbstractAlarmsEventsView.this.processQueue();
                            }
                        });
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        Collection<Runnable> list = null;
        Object object = this.jobLock;
        synchronized (object) {
            list = this.taskList;
            this.taskList = null;
        }
        if (list != null) {
            for (Runnable r : list) {
                r.run();
            }
        }
    }

    protected String getLabelForConnection() {
        if (this.getConnection() != null) {
            ConnectionState state = this.getConnection().getState();
            if (state == ConnectionState.BOUND) {
                return String.format(Messages.AbstractAlarmsEventsView_Label_Format_Connected, this.makeStringFromConnection(this.getConnection()));
            }
            return String.format(Messages.AbstractAlarmsEventsView_Label_Format_Disconnected, state, this.makeStringFromConnection(this.getConnection()));
        }
        return String.format(Messages.AbstractAlarmsEventsView_Label_Format_NoConnection, this.makeStringFromConnection(this.getConnection()));
    }

    protected String makeStringFromConnection(org.eclipse.scada.ae.client.Connection connection) {
        if (connection == null) {
            return Messages.AbstractAlarmsEventsView_Label_Format_NoConnection_String;
        }
        ConnectionInformation ci = connection.getConnectionInformation();
        if (ci == null) {
            return Messages.AbstractAlarmsEventsView_Label_Format_NoConnection_String;
        }
        return ci.toMaskedString();
    }
}

