/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.ui.views.Activator;
import org.eclipse.scada.ae.ui.views.model.DecoratedEvent;
import org.eclipse.scada.ae.ui.views.views.Messages;
import org.eclipse.scada.core.Variant;
import org.eclipse.swt.graphics.Image;

public class LabelProviderSupport {
    private final DateFormat df;
    private final DateFormat tf;
    public static final NumberFormat nf3 = new DecimalFormat(Messages.LabelProviderSupport_Format_NF3);
    public static final NumberFormat nf6 = new DecimalFormat(Messages.LabelProviderSupport_Format_NF6);
    private final Image alarmImage;
    private final Image ackImage = Activator.getImageDescriptor("icons/monitor_ack.png").createImage();
    private final Image emptyImage = Activator.getImageDescriptor("icons/monitor_empty.png").createImage();
    private final Image okImage = Activator.getImageDescriptor("icons/monitor_ok.png").createImage();
    private final Image maualImage;
    private final Image disconnectedImage;
    private final Image warningImage;
    private final Image userImage = Activator.getImageDescriptor("icons/user_icon.gif").createImage();
    private final Image systemImage = Activator.getImageDescriptor("icons/system_icon.gif").createImage();

    public LabelProviderSupport(TimeZone timeZone) {
        this.df = new SimpleDateFormat(Messages.LabelProviderSupport_DateTimeFormat);
        this.df.setTimeZone(timeZone);
        this.tf = new SimpleDateFormat(Messages.LabelProviderSupport_TimeFormat);
        this.tf.setTimeZone(timeZone);
        this.alarmImage = org.eclipse.scada.core.ui.styles.Activator.getDefault().getImageRegistry().getDescriptor("alarm").createImage();
        this.warningImage = org.eclipse.scada.core.ui.styles.Activator.getDefault().getImageRegistry().getDescriptor("warning").createImage();
        this.maualImage = org.eclipse.scada.core.ui.styles.Activator.getDefault().getImageRegistry().getDescriptor("manual").createImage();
        this.disconnectedImage = org.eclipse.scada.core.ui.styles.Activator.getDefault().getImageRegistry().getDescriptor("disconnected").createImage();
    }

    public DateFormat getDf() {
        return this.df;
    }

    public DateFormat getTf() {
        return this.tf;
    }

    public String toLabel(Variant value) {
        if (value == null) {
            return "";
        }
        if (value.isDouble()) {
            Double v = value.asDouble(Double.valueOf(0.0));
            if (v < 1000.0) {
                return nf6.format(v);
            }
            return nf3.format(v);
        }
        return value.toLabel("");
    }

    public String formatDate(Long date) {
        if (date == null) {
            return "";
        }
        return this.formatDate(new Date(date));
    }

    public String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        switch (this.toSpecial(date)) {
            case YESTERDAY: {
                return String.format(Messages.LabelProviderSupport_SpecialFormat_Yesterday, this.tf.format(date));
            }
            case TODAY: {
                return String.format(Messages.LabelProviderSupport_SpecialFormat_Today, this.tf.format(date));
            }
        }
        return this.df.format(date);
    }

    public String toLabel(DecoratedEvent event, String key) {
        return this.toLabel((Variant)event.getEvent().getAttributes().get(key));
    }

    private SpecialDate toSpecial(Date date) {
        return SpecialDate.PAST;
    }

    public void decorateWithActorType(DecoratedEvent event, ViewerCell cell) {
        String value = Variant.valueOf((Object)event.getEvent().getField(Event.Fields.ACTOR_TYPE)).asString("");
        if ("USER".equalsIgnoreCase(value)) {
            cell.setImage(this.userImage);
        } else if ("SYSTEM".equalsIgnoreCase(value)) {
            cell.setImage(this.systemImage);
        } else {
            cell.setImage(null);
        }
    }

    public void decorateWithMonitorState(DecoratedEvent event, ViewerCell cell) {
        if (!event.isActive()) {
            cell.setImage(null);
        } else {
            switch (event.getMonitor().getStatus()) {
                case NOT_OK: 
                case NOT_OK_AKN: {
                    if (event.getMonitor().getSeverity() == Severity.WARNING) {
                        cell.setImage(this.warningImage);
                        break;
                    }
                    cell.setImage(this.alarmImage);
                    break;
                }
                case NOT_AKN: {
                    cell.setImage(this.ackImage);
                    break;
                }
                case NOT_OK_NOT_AKN: {
                    cell.setImage(this.ackImage);
                    break;
                }
            }
        }
    }

    public void dispose() {
        this.alarmImage.dispose();
        this.ackImage.dispose();
        this.emptyImage.dispose();
        this.okImage.dispose();
        this.maualImage.dispose();
        this.disconnectedImage.dispose();
        this.userImage.dispose();
        this.systemImage.dispose();
        this.warningImage.dispose();
    }

    public Image getWarningImage() {
        return this.warningImage;
    }

    public Image getAlarmImage() {
        return this.alarmImage;
    }

    public Image getAckImage() {
        return this.ackImage;
    }

    public Image getEmptyImage() {
        return this.emptyImage;
    }

    public Image getOkImage() {
        return this.okImage;
    }

    public Image getMaualImage() {
        return this.maualImage;
    }

    public Image getDisconnectedImage() {
        return this.disconnectedImage;
    }

    public Image getUserImage() {
        return this.userImage;
    }

    public Image getSystemImage() {
        return this.systemImage;
    }

    private static enum SpecialDate {
        PAST,
        YESTERDAY,
        TODAY,
        TOMORROW,
        FUTURE;

    }
}

