/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.scada.ae.ui.views.Messages;
import org.eclipse.scada.ae.ui.views.Settings;
import org.eclipse.scada.ae.ui.views.model.DecoratedMonitor;
import org.eclipse.scada.ae.ui.views.model.MonitorData;
import org.eclipse.scada.ae.ui.views.views.ColumnProperties;
import org.eclipse.scada.ae.ui.views.views.MonitorTableLabelProvider;
import org.eclipse.scada.core.Variant;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;

public class MonitorsViewTable
extends Composite {
    private static final String COLUMN_KEY = "org.eclipse.scada.ae.ui.views.views.MonitorsViewTable.column.key";
    private static final Date DEFAULT_DATE = new Date(0L);
    private final AtomicReference<TableViewer> tableRef = new AtomicReference<Object>(null);
    private final WritableSet monitors;
    private final TableViewer tableViewer;
    private volatile boolean scrollLock = false;

    public MonitorsViewTable(Composite parent, IViewSite viewSite, int style, WritableSet monitors, List<ColumnProperties> columnSettings) {
        super(parent, style);
        this.monitors = monitors;
        FillLayout layout = new FillLayout();
        this.setLayout((Layout)layout);
        this.tableViewer = new TableViewer((Composite)this, 66306);
        this.tableRef.set(this.tableViewer);
        this.createColumns(this.tableViewer);
        this.applyColumSettings(columnSettings);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setSorter((ViewerSorter)new Sorter(Columns.LAST_FAIL_TIMESTAMP, 1024));
        this.tableViewer.getTable().setSortDirection(1024);
        this.hookContextMenu(this.tableViewer.getControl(), (ISelectionProvider)this.tableViewer, viewSite);
        viewSite.setSelectionProvider((ISelectionProvider)this.tableViewer);
        ObservableSetContentProvider contentProvider = new ObservableSetContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MonitorTableLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])BeanProperties.values((String[])new String[]{"id", "monitor"})), Settings.getTimeZone()));
        this.tableViewer.setInput((Object)this.monitors);
        contentProvider.getRealizedElements().addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                if (!MonitorsViewTable.this.scrollLock) {
                    MonitorsViewTable.this.tableViewer.getTable().setTopIndex(0);
                }
            }
        });
    }

    protected void hookContextMenu(Control control, ISelectionProvider selectionProvider, IViewSite viewSite) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MonitorsViewTable.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        viewSite.registerContextMenu(menuMgr, selectionProvider);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void createColumns(TableViewer table) {
        SortListener sortListener = new SortListener(table);
        TableViewerColumn idColumn = new TableViewerColumn(table, 0);
        idColumn.getColumn().setText(Messages.ID);
        idColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.ID);
        idColumn.getColumn().setWidth(450);
        idColumn.getColumn().setResizable(true);
        idColumn.getColumn().setMoveable(true);
        idColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn stateColumn = new TableViewerColumn(table, 0);
        stateColumn.getColumn().setText(Messages.State);
        stateColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.STATE);
        stateColumn.getColumn().setWidth(150);
        stateColumn.getColumn().setResizable(true);
        stateColumn.getColumn().setMoveable(true);
        stateColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn timestampColumn = new TableViewerColumn(table, 0);
        timestampColumn.getColumn().setText(Messages.Timestamp);
        timestampColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.LAST_FAIL_TIMESTAMP);
        timestampColumn.getColumn().setWidth(180);
        timestampColumn.getColumn().setResizable(true);
        timestampColumn.getColumn().setMoveable(true);
        timestampColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn lastFailValueColumn = new TableViewerColumn(table, 0);
        lastFailValueColumn.getColumn().setText(Messages.MonitorsViewTable_LastFailValue);
        lastFailValueColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.LAST_FAIL_VALUE);
        lastFailValueColumn.getColumn().setWidth(100);
        lastFailValueColumn.getColumn().setResizable(true);
        lastFailValueColumn.getColumn().setMoveable(true);
        lastFailValueColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn valueColumn = new TableViewerColumn(table, 0);
        valueColumn.getColumn().setText(Messages.Value);
        valueColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.VALUE);
        valueColumn.getColumn().setWidth(100);
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setMoveable(true);
        valueColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn aknUserColumn = new TableViewerColumn(table, 0);
        aknUserColumn.getColumn().setText(Messages.AckUser);
        aknUserColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.ACK_USER);
        aknUserColumn.getColumn().setWidth(150);
        aknUserColumn.getColumn().setResizable(true);
        aknUserColumn.getColumn().setMoveable(false);
        aknUserColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn aknTimestampColumn = new TableViewerColumn(table, 0);
        aknTimestampColumn.getColumn().setText(Messages.AckTimestamp);
        aknTimestampColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.ACK_TIMESTAMP);
        aknTimestampColumn.getColumn().setWidth(180);
        aknTimestampColumn.getColumn().setResizable(true);
        aknTimestampColumn.getColumn().setMoveable(true);
        aknTimestampColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn itemColumn = new TableViewerColumn(table, 0);
        itemColumn.getColumn().setText(Messages.Item);
        itemColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.ITEM);
        itemColumn.getColumn().setWidth(180);
        itemColumn.getColumn().setResizable(true);
        itemColumn.getColumn().setMoveable(true);
        itemColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn itemDescriptionolumn = new TableViewerColumn(table, 0);
        itemDescriptionolumn.getColumn().setText(Messages.ItemDescription);
        itemDescriptionolumn.getColumn().setData(COLUMN_KEY, (Object)Columns.ITEM_DESCRIPTION);
        itemDescriptionolumn.getColumn().setWidth(180);
        itemDescriptionolumn.getColumn().setResizable(true);
        itemDescriptionolumn.getColumn().setMoveable(true);
        itemDescriptionolumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn messageColumn = new TableViewerColumn(table, 0);
        messageColumn.getColumn().setText(Messages.Message);
        messageColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.MESSAGE);
        messageColumn.getColumn().setWidth(180);
        messageColumn.getColumn().setResizable(true);
        messageColumn.getColumn().setMoveable(true);
        messageColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn statusTimestampColumn = new TableViewerColumn(table, 0);
        statusTimestampColumn.getColumn().setText(Messages.MonitorsViewTable_StatusTimestamp);
        statusTimestampColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.STATUS_TIMESTAMP);
        statusTimestampColumn.getColumn().setWidth(180);
        statusTimestampColumn.getColumn().setResizable(true);
        statusTimestampColumn.getColumn().setMoveable(true);
        statusTimestampColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
        TableViewerColumn severityColumn = new TableViewerColumn(table, 0);
        severityColumn.getColumn().setText(Messages.MonitorsViewTable_Severity);
        severityColumn.getColumn().setData(COLUMN_KEY, (Object)Columns.SEVERITY);
        severityColumn.getColumn().setWidth(180);
        severityColumn.getColumn().setResizable(true);
        severityColumn.getColumn().setMoveable(true);
        severityColumn.getColumn().addSelectionListener((SelectionListener)sortListener);
    }

    public void clear() {
        this.monitors.clear();
    }

    public List<DecoratedMonitor> selectedMonitors() {
        if (this.tableRef.get().getTable().getSelectionCount() == 0) {
            return new ArrayList<DecoratedMonitor>();
        }
        ArrayList<DecoratedMonitor> result = new ArrayList<DecoratedMonitor>();
        TableItem[] tableItemArray = this.tableRef.get().getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem row = tableItemArray[n2];
            if (row.getData() instanceof DecoratedMonitor) {
                result.add((DecoratedMonitor)row.getData());
            }
            ++n2;
        }
        return result;
    }

    public int numOfEntries() {
        return this.monitors.size();
    }

    public void applyColumSettings(List<ColumnProperties> columnSettings) {
        if (columnSettings == null) {
            return;
        }
        int[] colOrder = this.tableViewer.getTable().getColumnOrder();
        int i = 0;
        for (ColumnProperties p : columnSettings) {
            if (i >= colOrder.length) break;
            colOrder[i] = p.getNo();
            ++i;
        }
        this.tableViewer.getTable().setColumnOrder(colOrder);
        i = 0;
        for (ColumnProperties p : columnSettings) {
            if (i >= this.tableViewer.getTable().getColumnCount()) break;
            TableColumn col = this.tableViewer.getTable().getColumn(i);
            col.setWidth(p.getWidth());
            ++i;
        }
    }

    public List<ColumnProperties> getColumnSettings() {
        ArrayList<ColumnProperties> result = new ArrayList<ColumnProperties>();
        int i = 0;
        int[] order = this.tableViewer.getTable().getColumnOrder();
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            result.add(new ColumnProperties(order[i], col.getWidth()));
            ++i;
            ++n2;
        }
        return result;
    }

    private static enum Columns {
        ID,
        STATE,
        LAST_FAIL_TIMESTAMP,
        LAST_FAIL_VALUE,
        VALUE,
        ACK_USER,
        ACK_TIMESTAMP,
        ITEM,
        ITEM_DESCRIPTION,
        MESSAGE,
        STATUS_TIMESTAMP,
        SEVERITY;

    }

    private static class SortListener
    extends SelectionAdapter {
        private final TableViewer tableViewer;

        public SortListener(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            Table table = this.tableViewer.getTable();
            TableColumn newColumn = (TableColumn)e.widget;
            TableColumn currentColumn = table.getSortColumn();
            int currentDir = table.getSortDirection();
            int newDir = 128;
            if (newColumn == currentColumn) {
                newDir = currentDir == 128 ? 1024 : 128;
            } else {
                table.setSortColumn(newColumn);
            }
            table.setSortDirection(newDir);
            this.tableViewer.setSorter((ViewerSorter)new Sorter((Columns)((Object)newColumn.getData(MonitorsViewTable.COLUMN_KEY)), newDir));
        }
    }

    private static class Sorter
    extends ViewerSorter {
        private final Columns column;
        private final int dir;

        public Sorter(Columns column, int dir) {
            this.column = column;
            this.dir = dir;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            MonitorData m1 = ((DecoratedMonitor)e1).getMonitor();
            MonitorData m2 = ((DecoratedMonitor)e2).getMonitor();
            Object v1 = 0;
            Object v2 = 0;
            switch (this.column) {
                case ID: {
                    v1 = m1.getId();
                    v2 = m2.getId();
                    break;
                }
                case STATE: {
                    v1 = m1.getStatus();
                    v2 = m2.getStatus();
                    break;
                }
                case VALUE: {
                    v1 = m1.getValue() == null ? Variant.NULL : m1.getValue();
                    v2 = m2.getValue() == null ? Variant.NULL : m2.getValue();
                    break;
                }
                case LAST_FAIL_TIMESTAMP: {
                    v1 = m1.getLastFailTimestamp();
                    v2 = m2.getLastFailTimestamp();
                    break;
                }
                case LAST_FAIL_VALUE: {
                    v1 = m1.getLastFailValue() == null ? Variant.NULL : m1.getLastFailValue();
                    v2 = m2.getLastFailValue() == null ? Variant.NULL : m2.getLastFailValue();
                    break;
                }
                case ACK_USER: {
                    v1 = m1.getLastAknUser() == null ? "" : m1.getLastAknUser();
                    v2 = m2.getLastAknUser() == null ? "" : m2.getLastAknUser();
                    break;
                }
                case ACK_TIMESTAMP: {
                    v1 = m1.getLastAknTimestamp() == null ? DEFAULT_DATE : m1.getLastAknTimestamp();
                    v2 = m2.getLastAknTimestamp() == null ? DEFAULT_DATE : m2.getLastAknTimestamp();
                    break;
                }
                case ITEM: {
                    v1 = m1.getAttributes().get("item") == null ? Variant.NULL : (Variant)m1.getAttributes().get("item");
                    v2 = m2.getAttributes().get("item") == null ? Variant.NULL : (Variant)m2.getAttributes().get("item");
                    break;
                }
                case ITEM_DESCRIPTION: {
                    v1 = m1.getAttributes().get("itemDescription") == null ? Variant.NULL : (Variant)m1.getAttributes().get("itemDescription");
                    v2 = m2.getAttributes().get("itemDescription") == null ? Variant.NULL : (Variant)m2.getAttributes().get("itemDescription");
                    break;
                }
                case MESSAGE: {
                    v1 = m1.getAttributes().get("message") == null ? Variant.NULL : (Variant)m1.getAttributes().get("message");
                    v2 = m2.getAttributes().get("message") == null ? Variant.NULL : (Variant)m2.getAttributes().get("message");
                    break;
                }
                case STATUS_TIMESTAMP: {
                    v1 = m1.getStatusTimestamp();
                    v2 = m2.getStatusTimestamp();
                    break;
                }
                case SEVERITY: {
                    v1 = m1.getSeverity();
                    v2 = m2.getSeverity();
                }
            }
            if (v1 == v2) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            int result = v1.compareTo(v2);
            int n = result = this.dir == 1024 ? -result : result;
            if (this.column != Columns.LAST_FAIL_TIMESTAMP && result == 0) {
                result = Long.valueOf(m2.getStatusTimestamp()).compareTo(m1.getStatusTimestamp());
            }
            if (this.column != Columns.ID && result == 0) {
                result = m1.getId().compareTo(m2.getId());
            }
            return result;
        }
    }
}

